/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.model.Named;
import com.globalmentor.net.Authenticable;
import io.clogr.Clogged;
import java.time.LocalDate;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface Application
extends Runnable,
Named<String>,
Clogged {
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_SOFTWARE = 1;
    public static final int EXIT_CODE_USAGE = 2;
    public static final int EXIT_CODE_CONTINUE = -1;
    public static final String[] NO_ARGUMENTS = new String[0];

    public Optional<Authenticable> getAuthenticator();

    public String[] getArgs();

    public String getVersion();

    public boolean isDebug();

    public Preferences getPreferences() throws SecurityException;

    public Optional<LocalDate> getExpirationDate();

    public void initialize() throws Exception;

    public int start();

    public static void start(@Nonnull Application application) {
        int result = 0;
        try {
            try {
                application.initialize();
                result = application.start();
            }
            catch (Throwable throwable) {
                result = 1;
                application.reportError("Error starting application.", throwable);
            }
        }
        finally {
            if (result >= 0) {
                application.end(result);
            }
        }
    }

    default public void end() {
        this.end(0);
    }

    public void end(@Nonnegative int var1);

    default public void exit(int status) {
        System.exit(status);
    }

    public void reportError(@Nonnull Throwable var1);

    public void reportError(@Nonnull String var1, @Nonnull Throwable var2);

    public void reportError(@Nonnull String var1);
}

