/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.application.Application;
import com.globalmentor.java.Conditions;
import com.globalmentor.net.Authenticable;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractApplication
implements Application {
    private Authenticable authenticator = null;
    private final String[] args;
    private LocalDate expirationDate = null;

    @Override
    public Optional<Authenticable> getAuthenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    protected void setAuthenticator(@Nullable Authenticable authenticable) {
        if (this.authenticator != authenticable) {
            this.authenticator = authenticable;
        }
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Preferences getPreferences() throws SecurityException {
        return Preferences.userNodeForPackage(this.getClass());
    }

    @Override
    public Optional<LocalDate> getExpirationDate() {
        return Optional.ofNullable(this.expirationDate);
    }

    protected void setExpirationDate(@Nullable LocalDate newExpirationDate) {
        this.expirationDate = newExpirationDate;
    }

    public AbstractApplication() {
        this(NO_ARGUMENTS);
    }

    public AbstractApplication(@Nonnull String[] args) {
        this.args = Objects.requireNonNull(args);
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public int start() {
        return this.canStart() ? this.execute() : 1;
    }

    protected int execute() {
        this.run();
        return 0;
    }

    protected boolean canStart() {
        boolean isExpired = this.getExpirationDate().map(expirationDate -> !LocalDate.now().isAfter((ChronoLocalDate)expirationDate)).orElse(false);
        if (isExpired) {
            this.reportError("This version of " + (String)this.getName() + " has expired.");
            return false;
        }
        return true;
    }

    @Override
    public final void end(int status) {
        Conditions.checkArgumentNotNegative((int)status);
        if (this.canEnd()) {
            try {
                this.exit(status);
            }
            catch (Throwable throwable) {
                this.reportError("Error exiting.", throwable);
            }
            System.exit(-1);
        }
    }

    protected boolean canEnd() {
        return true;
    }

    @Override
    public void reportError(Throwable throwable) {
        this.reportError(this.toErrorMessage(throwable), throwable);
    }

    @Override
    public void reportError(@Nonnull String message, @Nonnull Throwable throwable) {
        this.reportError(message);
        throwable.printStackTrace(System.err);
    }

    @Override
    public void reportError(String message) {
        System.err.println(message);
    }

    @Nonnull
    protected String toErrorMessage(Throwable throwable) {
        if (throwable instanceof FileNotFoundException) {
            return "File or directory not found: " + throwable.getMessage();
        }
        if (throwable instanceof NoSuchFileException) {
            return "No such file or directory: " + throwable.getMessage();
        }
        String message = throwable.getMessage();
        return message != null ? message : throwable.getClass().getName();
    }
}

