/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.application.AbstractApplication;
import com.globalmentor.application.Application;
import io.clogr.Clogr;
import io.confound.config.Configuration;
import io.confound.config.ConfigurationException;
import io.confound.config.file.AbstractFileConfigurationManager;
import io.confound.config.file.ResourcesConfigurationManager;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.event.Level;
import picocli.CommandLine;

public abstract class BaseCliApplication
extends AbstractApplication {
    public static final String CONFIG_KEY_NAME = "name";
    public static final String CONFIG_KEY_VERSION = "version";
    private boolean debug;

    public String getName() {
        try {
            return ((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.getClass()).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(CONFIG_KEY_NAME);
        }
        catch (IOException ioException) {
            throw new ConfigurationException((Throwable)ioException);
        }
    }

    @Override
    public String getVersion() {
        try {
            return ((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.getClass()).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(CONFIG_KEY_VERSION);
        }
        catch (IOException ioException) {
            throw new ConfigurationException((Throwable)ioException);
        }
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @CommandLine.Option(names={"--debug", "-d"}, description={"Turns on debug level logging."})
    protected void setDebug(boolean debug) {
        this.debug = debug;
        this.updateLogLevel();
    }

    protected void updateLogLevel() {
        Level logLevel = this.debug ? Level.DEBUG : Level.WARN;
        Clogr.getLoggingConcern().setLogLevel(logLevel);
    }

    public BaseCliApplication(@Nonnull String[] args) {
        super(args);
        this.updateLogLevel();
    }

    @Override
    public int start() {
        CommandLine.run((Runnable)this, (String[])this.getArgs());
        return 0;
    }

    @Override
    public void run() {
        CommandLine.usage((Object)this, (PrintStream)System.out);
    }

    protected static abstract class AbstractMetadataProvider
    implements CommandLine.IVersionProvider {
        private final Class<? extends Application> applicationClass;

        public String[] getVersion() throws Exception {
            return new String[]{((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.applicationClass).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(BaseCliApplication.CONFIG_KEY_VERSION)};
        }

        public AbstractMetadataProvider(@Nonnull Class<? extends Application> applicationClass) {
            this.applicationClass = Objects.requireNonNull(applicationClass);
        }
    }
}

