/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.model.Named;
import com.globalmentor.net.Authenticable;
import io.clogr.Clogged;
import java.time.LocalDate;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import org.fusesource.jansi.AnsiConsole;

public interface Application
extends Runnable,
Named<String>,
Clogged {
    public static final String[] NO_ARGUMENTS = new String[0];

    public Optional<Authenticable> getAuthenticator();

    public String[] getArgs();

    public String getVersion();

    public boolean isDebug();

    public Preferences getPreferences() throws SecurityException;

    public Optional<LocalDate> getExpirationDate();

    public void initialize() throws Exception;

    default public int start() {
        this.run();
        return 0;
    }

    public boolean canStart();

    @Deprecated
    public void displayError(@Nonnull String var1, @Nonnull Throwable var2);

    @Deprecated
    public void displayError(String var1);

    default public void exit() {
        this.exit(0);
    }

    public void exit(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int start(Application application) {
        AnsiConsole.systemInstall();
        try {
            int result = 0;
            try {
                application.initialize();
                result = application.canStart() ? application.start() : -1;
            }
            catch (Throwable throwable) {
                result = -1;
                application.displayError("Error starting application.", throwable);
            }
            if (result < 0) {
                try {
                    application.exit(result);
                }
                catch (Throwable throwable) {
                    result = -1;
                    application.displayError("Error exiting application.", throwable);
                }
                finally {
                    System.exit(result);
                }
            }
            int n = result;
            return n;
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }
}

