/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.application.Application;
import com.globalmentor.net.Authenticable;
import java.io.FileNotFoundException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractApplication
implements Application {
    private Authenticable authenticator = null;
    private final String[] args;
    private LocalDate expirationDate = null;

    @Override
    public Optional<Authenticable> getAuthenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    protected void setAuthenticator(@Nullable Authenticable authenticable) {
        if (this.authenticator != authenticable) {
            this.authenticator = authenticable;
        }
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Preferences getPreferences() throws SecurityException {
        return Preferences.userNodeForPackage(this.getClass());
    }

    @Override
    public Optional<LocalDate> getExpirationDate() {
        return Optional.ofNullable(this.expirationDate);
    }

    protected void setExpirationDate(@Nullable LocalDate newExpirationDate) {
        this.expirationDate = newExpirationDate;
    }

    public AbstractApplication() {
        this(NO_ARGUMENTS);
    }

    public AbstractApplication(@Nonnull String[] args) {
        this.args = Objects.requireNonNull(args);
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public boolean canStart() {
        boolean isExpired = this.getExpirationDate().map(expirationDate -> !LocalDate.now().isAfter((ChronoLocalDate)expirationDate)).orElse(false);
        if (isExpired) {
            this.displayError("This version of " + (String)this.getName() + " has expired.");
            return false;
        }
        return true;
    }

    @Override
    public void displayError(@Nonnull String message, @Nonnull Throwable throwable) {
        this.getLogger().error(message, throwable);
        this.displayError(AbstractApplication.getDisplayErrorMessage(throwable));
    }

    @Override
    public void displayError(String message) {
        System.err.println(message);
    }

    protected static String getDisplayErrorMessage(Throwable throwable) {
        if (throwable instanceof FileNotFoundException) {
            return "File not found: " + throwable.getMessage();
        }
        return throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
    }

    protected boolean canExit() {
        return true;
    }

    @Override
    public final void exit(int status) {
        if (this.canExit()) {
            try {
                this.performExit(status);
            }
            catch (Throwable throwable) {
                this.displayError("Error exiting.", throwable);
            }
            System.exit(-1);
        }
    }

    protected void performExit(int status) throws Exception {
        System.exit(status);
    }
}

