/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.java.Enums;
import com.globalmentor.lex.Identifier;
import com.globalmentor.log.DefaultLogConfiguration;
import com.globalmentor.log.Log;
import com.globalmentor.log.LogConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineArguments {
    public static final String LONG_SWITCH_DELIMITER = "--";
    public static final Pattern SWITCH_PATTERN = Pattern.compile("--([\\w-&&[^=:]]+)(?:=(.+)?)");
    public static final Pattern FLAG_PATTERN = Pattern.compile("--([\\w-&&[^=:]]+)");
    public static final Pattern OPTION_PATTERN = Pattern.compile("--([\\w-&&[^=:]]+)[=:](.+)");

    protected CommandLineArguments() {
    }

    public static void configureLog(String[] arguments) {
        String logFileOption;
        Log.Level logLevel = CommandLineArguments.getOption(arguments, Switch.LOG_LEVEL, Log.Level.class);
        if (logLevel == null) {
            logLevel = CommandLineArguments.hasFlag(arguments, Switch.VERBOSE) ? Log.Level.DEBUG : (CommandLineArguments.hasFlag(arguments, Switch.QUIET) ? Log.Level.WARN : Log.Level.INFO);
        }
        File logFile = (logFileOption = CommandLineArguments.getOption(arguments, Switch.LOG_FILE)) != null ? new File(logFileOption) : null;
        Log.setDefaultConfiguration((LogConfiguration)new DefaultLogConfiguration(logFile, logLevel));
    }

    public static boolean hasHelpFlag(String[] arguments) {
        return CommandLineArguments.hasFlag(arguments, Switch.HELP);
    }

    public static <F extends Enum<F>> boolean hasFlag(String[] arguments, F flag) {
        return CommandLineArguments.hasFlag(arguments, Enums.getSerializationName(flag));
    }

    public static boolean hasFlag(String[] arguments, String flagName) {
        for (int i = 0; i < arguments.length; ++i) {
            Matcher flagMatcher = FLAG_PATTERN.matcher(arguments[i]);
            if (!flagMatcher.matches() || !flagName.equals(flagMatcher.group(1))) continue;
            return true;
        }
        return false;
    }

    public static <O extends Enum<O>, V extends Enum<V>> V getOption(String[] arguments, O option, Class<V> valueType) {
        return CommandLineArguments.getOption(arguments, Enums.getSerializationName(option), valueType);
    }

    public static <O extends Enum<O>> String getOption(String[] arguments, O option) {
        return CommandLineArguments.getOption(arguments, Enums.getSerializationName(option));
    }

    public static <V extends Enum<V>> V getOption(String[] arguments, String optionName, Class<V> valueType) {
        String optionValue = CommandLineArguments.getOption(arguments, optionName);
        return (V)(optionValue != null ? Enums.getSerializedEnum(valueType, (String)optionValue) : null);
    }

    public static String getOption(String[] arguments, String optionName) {
        for (int i = arguments.length - 1; i >= 0; --i) {
            Matcher optionMatcher = OPTION_PATTERN.matcher(arguments[i]);
            if (!optionMatcher.matches() || !optionName.equals(optionMatcher.group(1))) continue;
            return optionMatcher.group(2);
        }
        return null;
    }

    public static <O extends Enum<O>> List<String> getOptions(String[] arguments, O option) {
        return CommandLineArguments.getOptions(arguments, Enums.getSerializationName(option));
    }

    public static List<String> getOptions(String[] arguments, String optionName) {
        int argumentCount = arguments.length;
        List<String> options = null;
        for (int i = 0; i < argumentCount; ++i) {
            Matcher optionMatcher = OPTION_PATTERN.matcher(arguments[i]);
            if (!optionMatcher.matches() || !optionName.equals(optionMatcher.group(1))) continue;
            if (options == null) {
                options = new ArrayList<String>();
            }
            options.add(optionMatcher.group(2));
        }
        return options != null ? options : Collections.emptyList();
    }

    public static boolean isSwitch(String argument) {
        return SWITCH_PATTERN.matcher(argument).matches();
    }

    @Deprecated
    public static String createSwitch(String switchString) {
        return LONG_SWITCH_DELIMITER + switchString;
    }

    public static enum Switch implements Identifier
    {
        VERBOSE,
        QUIET,
        HELP,
        LOG_FILE,
        LOG_LEVEL;

    }
}

