/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.application.Application;
import com.globalmentor.application.CommandLineArguments;
import com.globalmentor.java.Objects;
import com.globalmentor.log.Log;
import com.globalmentor.net.Authenticable;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Date;
import java.util.prefs.Preferences;

public abstract class AbstractApplication
implements Application {
    private final URI uri;
    private final String name;
    private Authenticable authenticator = null;
    private final String[] args;
    private Date expirationDate = null;

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Authenticable getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(Authenticable authenticable) {
        if (this.authenticator != authenticable) {
            this.authenticator = authenticable;
        }
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Preferences getPreferences() throws SecurityException {
        return Preferences.userNodeForPackage(this.getClass());
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    protected void setExpiration(Date newExpirationDate) {
        this.expirationDate = newExpirationDate;
    }

    public AbstractApplication(URI uri, String name) {
        this(uri, name, NO_ARGUMENTS);
    }

    public AbstractApplication(URI uri, String name, String[] args) {
        this.uri = (URI)Objects.checkInstance((Object)uri);
        this.name = (String)Objects.checkInstance((Object)name);
        this.args = (String[])Objects.checkInstance((Object)args);
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public boolean canStart() {
        Date now;
        Date expirationDate = this.getExpirationDate();
        if (expirationDate != null && (now = new Date()).after(expirationDate)) {
            this.displayError("This version of " + this.getName() + " has expired.");
            return false;
        }
        return true;
    }

    @Override
    public void displayError(Throwable throwable) {
        Log.error((Object[])new Object[]{throwable});
        this.displayError(AbstractApplication.getDisplayErrorMessage(throwable));
    }

    @Override
    public void displayError(String message) {
        System.err.println(message);
    }

    public static String getDisplayErrorMessage(Throwable throwable) {
        if (throwable instanceof FileNotFoundException) {
            return "File not found: " + throwable.getMessage();
        }
        return throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(Application application, String[] args) {
        int result = 0;
        try {
            AbstractApplication.initialize(application, args);
            application.initialize();
            result = application.canStart() ? application.main() : -1;
        }
        catch (Throwable throwable) {
            result = -1;
            application.displayError(throwable);
        }
        if (result < 0) {
            try {
                application.exit(result);
            }
            catch (Throwable throwable) {
                result = -1;
                application.displayError(throwable);
            }
            finally {
                System.exit(result);
            }
        }
        return result;
    }

    protected static void initialize(Application application, String[] args) throws Exception {
        CommandLineArguments.configureLog(args);
    }

    protected boolean canExit() {
        return true;
    }

    @Override
    public final void exit() {
        this.exit(0);
    }

    @Override
    public final void exit(int status) {
        if (this.canExit()) {
            try {
                this.performExit(status);
            }
            catch (Throwable throwable) {
                this.displayError(throwable);
            }
            System.exit(-1);
        }
    }

    protected void performExit(int status) throws Exception {
        System.exit(status);
    }
}

