/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.page;

import com.gitlab.taucher2003.t2003_utils.tjda.page.Paginated;
import net.dv8tion.jda.api.entities.User;

public abstract class DefaultPagination
implements Paginated {
    private final int pageAmount;
    private int currentPage;

    public DefaultPagination(int pageAmount) {
        this.pageAmount = pageAmount;
    }

    @Override
    public void moveNext() {
        if (this.currentPage + 1 >= this.pageAmount) {
            this.currentPage = 0;
            return;
        }
        ++this.currentPage;
    }

    @Override
    public void movePrevious() {
        if (this.currentPage <= 0) {
            this.currentPage = this.pageAmount - 1;
            return;
        }
        --this.currentPage;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public int maxPages() {
        return this.pageAmount;
    }

    @Override
    public int currentPage() {
        return this.currentPage;
    }

    @Override
    public void movePage(int page) {
        if (page < 0 || page >= this.pageAmount) {
            return;
        }
        this.currentPage = page;
    }

    @Override
    public boolean canInteract(User user) {
        return true;
    }
}

