/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.Permissible;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SubCommand;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.SubCommandableMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;

public class SubCommandGroupMetaBuilder {
    private final String name;
    private final String description;
    private final Collection<SubCommand> subCommands = new ArrayList<SubCommand>();
    private Permissible permissible = Permissible.UNRESTRICTED;

    public SubCommandGroupMetaBuilder(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public SubCommandGroupMetaBuilder setSubCommands(Collection<SubCommand> subCommands) {
        this.subCommands.clear();
        this.subCommands.addAll(subCommands);
        return this;
    }

    public SubCommandGroupMetaBuilder addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    public SubCommandGroupMetaBuilder setPermissible(Permissible permissible) {
        this.permissible = permissible;
        return this;
    }

    public void configureSubCommandGroup(SubcommandGroupData data) {
        data.setName(this.name);
        data.setDescription(this.description);
        if (!this.subCommands.isEmpty()) {
            data.addSubcommands((Collection)this.subCommands.stream().map(SubCommand::asJdaObject).collect(Collectors.toList()));
        }
    }

    public SubCommandableMeta<SubcommandGroupData> build() {
        return new SubCommandableMeta<SubcommandGroupData>(this.name, this.description, this.permissible, this::configureSubCommandGroup, this.subCommands);
    }
}

