/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.CommandArgument;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.CommandGroup;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.Permissible;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SubCommand;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.RootCommandMetaBuilder;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.SubCommandGroupableMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;

public class CommandMetaBuilder
implements RootCommandMetaBuilder {
    private final String name;
    private final String description;
    private final Collection<CommandArgument> arguments = new ArrayList<CommandArgument>();
    private final Collection<CommandGroup> groups = new ArrayList<CommandGroup>();
    private final Collection<SubCommand> subCommands = new ArrayList<SubCommand>();
    private Permissible permissible = Permissible.UNRESTRICTED;

    public CommandMetaBuilder(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public CommandMetaBuilder setArguments(Collection<CommandArgument> arguments) {
        this.arguments.clear();
        this.arguments.addAll(arguments);
        return this;
    }

    @Override
    public CommandMetaBuilder addArgument(CommandArgument argument) {
        this.arguments.add(argument);
        return this;
    }

    @Override
    public CommandMetaBuilder setGroups(Collection<CommandGroup> arguments) {
        this.groups.clear();
        this.groups.addAll(arguments);
        return this;
    }

    @Override
    public CommandMetaBuilder addGroup(CommandGroup group) {
        this.groups.add(group);
        return this;
    }

    @Override
    public CommandMetaBuilder setSubCommands(Collection<SubCommand> subCommands) {
        this.subCommands.clear();
        this.subCommands.addAll(subCommands);
        return this;
    }

    @Override
    public CommandMetaBuilder addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    @Override
    public CommandMetaBuilder setPermissible(Permissible permissible) {
        this.permissible = permissible;
        return this;
    }

    public void configureCommand(SlashCommandData data) {
        data.setName(this.name);
        data.setDescription(this.description);
        if (!this.arguments.isEmpty()) {
            data.addOptions(new OptionData[0]).addOptions((Collection)this.arguments.stream().map(CommandArgument::asJdaObject).collect(Collectors.toList()));
        }
        if (!this.groups.isEmpty()) {
            data.addSubcommandGroups((Collection)this.groups.stream().map(CommandGroup::asJdaObject).collect(Collectors.toList()));
        }
        if (!this.subCommands.isEmpty()) {
            data.addSubcommands((Collection)this.subCommands.stream().map(SubCommand::asJdaObject).collect(Collectors.toList()));
        }
        data.setDefaultPermissions(DefaultMemberPermissions.enabledFor(this.permissible.defaultMemberPermissions()));
    }

    @Override
    public SubCommandGroupableMeta build() {
        return new SubCommandGroupableMeta(this.name, this.description, this.permissible, this::configureCommand, this.subCommands, this.groups);
    }
}

