/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands.build.argument;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.CommandArgument;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.argument.NumberArgumentBuilder;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.argument.StringArgumentBuilder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;

public class CommandArgumentBuilder
implements NumberArgumentBuilder,
StringArgumentBuilder {
    private final OptionType type;
    private final String name;
    private final String description;
    private boolean isRequired;
    private boolean isAutoComplete;
    private EnumSet<ChannelType> channelTypes;
    private Number minValue;
    private Number maxValue;
    private List<Command.Choice> choices;

    public CommandArgumentBuilder(OptionType type, String name, String description) {
        this.type = type;
        this.name = name;
        this.description = description;
    }

    @Override
    public CommandArgumentBuilder setRequired(boolean required) {
        this.isRequired = required;
        return this;
    }

    @Override
    public CommandArgumentBuilder setAutoComplete(boolean autoComplete) {
        this.isAutoComplete = autoComplete;
        return this;
    }

    public CommandArgumentBuilder setChannelTypes(Collection<ChannelType> channelTypes) {
        if (this.channelTypes == null) {
            this.channelTypes = EnumSet.noneOf(ChannelType.class);
        }
        this.channelTypes.clear();
        this.channelTypes.addAll(channelTypes);
        return this;
    }

    @Override
    public CommandArgumentBuilder setMinValue(Number minValue) {
        this.minValue = minValue;
        return this;
    }

    @Override
    public CommandArgumentBuilder setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @Override
    public CommandArgumentBuilder setMinLength(int minLength) {
        return this.setMinValue(minLength);
    }

    @Override
    public CommandArgumentBuilder setMaxLength(int maxLength) {
        return this.setMaxValue(maxLength);
    }

    @Override
    public CommandArgumentBuilder setChoices(List<Command.Choice> choices) {
        this.choices = choices;
        return this;
    }

    public void configureOption(OptionData data) {
        data.setName(this.name);
        data.setDescription(this.description);
        data.setRequired(this.isRequired);
        if (this.type.canSupportChoices()) {
            data.setAutoComplete(this.isAutoComplete);
        }
        if (this.type == OptionType.CHANNEL && this.channelTypes != null) {
            data.setChannelTypes(this.channelTypes);
        }
        if (this.type == OptionType.INTEGER || this.type == OptionType.NUMBER) {
            if (this.minValue != null) {
                data.setMinValue(this.minValue.longValue());
            }
            if (this.maxValue != null) {
                data.setMaxValue(this.maxValue.longValue());
            }
        }
        if (this.type == OptionType.STRING) {
            if (this.minValue != null) {
                data.setMinLength(this.minValue.intValue());
            }
            if (this.maxValue != null) {
                data.setMaxLength(this.maxValue.intValue());
            }
        }
        if (this.type.canSupportChoices() && !this.isAutoComplete && this.choices != null) {
            data.addChoices(this.choices);
        }
    }

    @Override
    public CommandArgument build() {
        return new CommandArgument(this.type, this::configureOption);
    }
}

