/*
 * Decompiled with CFR 0.152.
 */
package br.com.jhonsapp.notifier.email;

import br.com.jhonsapp.notifier.abstraction.Notification;
import org.springframework.util.StringUtils;

public class Message
implements Notification {
    private static final long serialVersionUID = 590642185867001972L;
    private String addressee;
    private String subject;
    private String message;

    private Message(String addressee, String subject, String message) {
        if (!StringUtils.hasText((String)addressee)) {
            throw new IllegalArgumentException("Email is required.");
        }
        if (!StringUtils.hasText((String)subject)) {
            throw new IllegalArgumentException("The subject is required.");
        }
        if (!StringUtils.hasText((String)message)) {
            throw new IllegalArgumentException("The message is required.");
        }
        this.addressee = addressee;
        this.subject = subject;
        this.message = message;
    }

    private Message(String addressee, String message) {
        if (!StringUtils.hasText((String)addressee)) {
            throw new IllegalArgumentException("Email is required.");
        }
        if (!StringUtils.hasText((String)message)) {
            throw new IllegalArgumentException("The message is required.");
        }
        this.addressee = addressee;
        this.subject = "";
        this.message = message;
    }

    @Override
    public String getAddressee() {
        return this.addressee.trim();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static final Message createMessage(String addressee, String subject, String message) {
        return new Message(addressee, subject, message);
    }

    public static final Message createMessage(String addressee, String message) {
        return new Message(addressee, message);
    }
}

