package br.com.jhonsapp.notifier.email;

import org.springframework.util.StringUtils;

import br.com.jhonsapp.notifier.abstraction.Notification;

/**
 * Class responsible for standardizing the structure of the message to be send.
 * 
 * @author Jhonathan Camacho
 *
 */
public class Message implements Notification{

	/**
	 * Generated serial version id created at 08 July 2017.
	 */
	private static final long serialVersionUID = 590642185867001972L;

	private String addressee;
	private String subject;
	private String message;

	private Message(String addressee, String subject, String message) {

		if (!StringUtils.hasText(addressee))
			throw new IllegalArgumentException("Email is required.");

		if (!StringUtils.hasText(subject))
			throw new IllegalArgumentException("The subject is required.");

		if (!StringUtils.hasText(message))
			throw new IllegalArgumentException("The message is required.");

		this.addressee = addressee;
		this.subject = subject;
		this.message = message;
	}

	private Message(String addressee, String message) {

		if (!StringUtils.hasText(addressee))
			throw new IllegalArgumentException("Email is required.");

		if (!StringUtils.hasText(message))
			throw new IllegalArgumentException("The message is required.");

		this.addressee = addressee;
		this.subject = "";
		this.message = message;
	}

	@Override
	public String getAddressee() {
		return addressee.trim();
	}

	@Override
	public String getSubject() {
		return subject;
	}

	@Override
	public String getMessage() {
		return message;
	}

	public static final Message createMessage(String addressee, String subject, String message) {
		return new Message(addressee, subject, message);
	}

	public static final Message createMessage(String addressee, String message) {
		return new Message(addressee, message);
	}

}