package br.com.jhonsapp.notifier.implementation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import br.com.jhonsapp.email.dispatcher.EmailService;
import br.com.jhonsapp.email.dispatcher.Message;

/**
 * Class responsible for sending notifications by email.
 * 
 * @see Notifier
 * 
 * @author Jhonathan Camacho
 */
@Service
public class NotifierByEmail implements Notifier {

	/**
	 * Generated serial version id created at 10 July 2017.
	 */
	private static final long serialVersionUID = -9145832296675317025L;

	@Autowired
	private EmailService emailService;
	
	@Override
	public boolean notify(Notification notification) {

		if (notification == null)
			throw new IllegalArgumentException("The notification can not be null.");

		Message message = Message.createMessage(notification.getSender(), notification.getSubject(), notification.getMessage());

		return emailService.send(message);
	}

}