package br.com.jhonsapp.notifier.implementation;

import java.io.Serializable;

/**
 * Interface responsible for sending notifications.
 * 
 * @author Jhonathan Camacho
 */
public interface Notifier extends Serializable {

	public static final String EMAIL = "EMAIL";
	
	
	/**
	 * Sends a notification to a destination.
	 * 
	 * @param notification
	 *            notification to be sent.
	 * 
	 * @return true if the notification was successfully sent and otherwise
	 *         false.
	 */
	public boolean notify(Notification notification);
}