package br.com.jhonsapp.notifier.abstraction;

import java.io.Serializable;

/**
 * Interface that defines a notification.
 * 
 * @author Jhonathan Camacho
 */
public interface Notification extends Serializable {

	/**
	 * Gets the addressee of the notification.
	 * 
	 * @return the addressee.
	 */
	public String getAddressee();

	/**
	 * Gets the subject of the notification.
	 * 
	 * @return the subject.
	 */
	public String getSubject();

	/**
	 * Gets the notification message.
	 * 
	 * @return the message.
	 */
	public String getMessage();
}