package br.com.jhonsapp.notifier.email;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

import br.com.jhonsapp.notifier.abstraction.Notification;
import br.com.jhonsapp.notifier.abstraction.Notifier;

/**
 * Class responsible for sending notifications by email.
 * 
 * @see Notifier
 * 
 * @author Jhonathan Camacho
 */
@Component
public class NotifierByEmail implements Notifier {

	/**
	 * Generated serial version id created at 15 August 2017.
	 */
	private static final long serialVersionUID = -9145832296675317025L;

	@Autowired
    public JavaMailSender emailSender;

	
	@Override
	public boolean notify(Notification notification) {

		if (notification == null)
			throw new IllegalArgumentException("The notification can not be null.");
		
		try {
	
	        SimpleMailMessage simpleMessage = new SimpleMailMessage(); 
	        simpleMessage.setTo(notification.getAddressee()); 
	        simpleMessage.setSubject(notification.getSubject()); 
	        simpleMessage.setText(notification.getMessage());
	        emailSender.send(simpleMessage);
			
			return true;
			
		} catch (MailException e) {
			return false;
		}
	}

}