/*
 * Decompiled with CFR 0.152.
 */
package com.mingle.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.mingle.shapeloading.R;
import com.nineoldandroids.animation.ArgbEvaluator;

public class ShapeLoadingView
extends View {
    private static final float genhao3 = 1.7320508f;
    private static final float mTriangle2Circle = 0.25555554f;
    private Shape mShape = Shape.SHAPE_CIRCLE;
    private Interpolator mInterpolator = new DecelerateInterpolator();
    private ArgbEvaluator mArgbEvaluator = new ArgbEvaluator();
    private int mTriangleColor;
    private int mCircleColor;
    private int mRectColor;
    private float mMagicNumber = 0.5522848f;
    public boolean mIsLoading = false;
    private Paint mPaint;
    private float mControlX = 0.0f;
    private float mControlY = 0.0f;
    private float mAnimPercent;

    public ShapeLoadingView(Context context) {
        super(context);
        this.init();
    }

    public ShapeLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ShapeLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ShapeLoadingView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(R.color.triangle));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.setBackgroundColor(this.getResources().getColor(R.color.view_bg));
        this.mTriangleColor = this.getResources().getColor(R.color.triangle);
        this.mCircleColor = this.getResources().getColor(R.color.circle);
        this.mRectColor = this.getResources().getColor(R.color.triangle);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getVisibility() == 8) {
            return;
        }
        switch (this.mShape) {
            case SHAPE_TRIANGLE: {
                if (this.mIsLoading) {
                    this.mAnimPercent = (float)((double)this.mAnimPercent + 0.1611113);
                    int color2 = (Integer)this.mArgbEvaluator.evaluate(this.mAnimPercent, (Object)this.mTriangleColor, (Object)this.mCircleColor);
                    this.mPaint.setColor(color2);
                    Path path = new Path();
                    path.moveTo(this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                    if (this.mAnimPercent >= 1.0f) {
                        this.mShape = Shape.SHAPE_CIRCLE;
                        this.mIsLoading = false;
                        this.mAnimPercent = 1.0f;
                    }
                    float controlX = this.mControlX - this.relativeXFromView(this.mAnimPercent * 0.25555554f) * 1.7320508f;
                    float controlY = this.mControlY - this.relativeYFromView(this.mAnimPercent * 0.25555554f);
                    path.quadTo(this.relativeXFromView(1.0f) - controlX, controlY, this.relativeXFromView(0.9330127f), this.relativeYFromView(0.75f));
                    path.quadTo(this.relativeXFromView(0.5f), this.relativeYFromView(0.75f + 2.0f * this.mAnimPercent * 0.25555554f), this.relativeXFromView(0.066987306f), this.relativeYFromView(0.75f));
                    path.quadTo(controlX, controlY, this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                    path.close();
                    canvas.drawPath(path, this.mPaint);
                    this.invalidate();
                    break;
                }
                Path path = new Path();
                this.mPaint.setColor(this.getResources().getColor(R.color.triangle));
                path.moveTo(this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                path.lineTo(this.relativeXFromView(1.0f), this.relativeYFromView(0.8660254f));
                path.lineTo(this.relativeXFromView(0.0f), this.relativeYFromView(0.8660254f));
                this.mControlX = this.relativeXFromView(0.28349364f);
                this.mControlY = this.relativeYFromView(0.375f);
                this.mAnimPercent = 0.0f;
                path.close();
                canvas.drawPath(path, this.mPaint);
                break;
            }
            case SHAPE_CIRCLE: {
                if (this.mIsLoading) {
                    float magicNumber = this.mMagicNumber + this.mAnimPercent;
                    this.mAnimPercent = (float)((double)this.mAnimPercent + 0.12);
                    if (magicNumber + this.mAnimPercent >= 1.9f) {
                        this.mShape = Shape.SHAPE_RECT;
                        this.mIsLoading = false;
                    }
                    int color3 = (Integer)this.mArgbEvaluator.evaluate(this.mAnimPercent, (Object)this.mCircleColor, (Object)this.mRectColor);
                    this.mPaint.setColor(color3);
                    Path path = new Path();
                    path.moveTo(this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                    path.cubicTo(this.relativeXFromView(0.5f + magicNumber / 2.0f), this.relativeYFromView(0.0f), this.relativeXFromView(1.0f), this.relativeYFromView(0.5f - magicNumber / 2.0f), this.relativeXFromView(1.0f), this.relativeYFromView(0.5f));
                    path.cubicTo(this.relativeXFromView(1.0f), this.relativeXFromView(0.5f + magicNumber / 2.0f), this.relativeXFromView(0.5f + magicNumber / 2.0f), this.relativeYFromView(1.0f), this.relativeXFromView(0.5f), this.relativeYFromView(1.0f));
                    path.cubicTo(this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeXFromView(1.0f), this.relativeXFromView(0.0f), this.relativeYFromView(0.5f + magicNumber / 2.0f), this.relativeXFromView(0.0f), this.relativeYFromView(0.5f));
                    path.cubicTo(this.relativeXFromView(0.0f), this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeYFromView(0.0f), this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                    path.close();
                    canvas.drawPath(path, this.mPaint);
                    this.invalidate();
                    break;
                }
                this.mPaint.setColor(this.getResources().getColor(R.color.circle));
                Path path = new Path();
                float magicNumber = this.mMagicNumber;
                path.moveTo(this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                path.cubicTo(this.relativeXFromView(0.5f + magicNumber / 2.0f), 0.0f, this.relativeXFromView(1.0f), this.relativeYFromView(magicNumber / 2.0f), this.relativeXFromView(1.0f), this.relativeYFromView(0.5f));
                path.cubicTo(this.relativeXFromView(1.0f), this.relativeXFromView(0.5f + magicNumber / 2.0f), this.relativeXFromView(0.5f + magicNumber / 2.0f), this.relativeYFromView(1.0f), this.relativeXFromView(0.5f), this.relativeYFromView(1.0f));
                path.cubicTo(this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeXFromView(1.0f), this.relativeXFromView(0.0f), this.relativeYFromView(0.5f + magicNumber / 2.0f), this.relativeXFromView(0.0f), this.relativeYFromView(0.5f));
                path.cubicTo(this.relativeXFromView(0.0f), this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeXFromView(0.5f - magicNumber / 2.0f), this.relativeYFromView(0.0f), this.relativeXFromView(0.5f), this.relativeYFromView(0.0f));
                this.mAnimPercent = 0.0f;
                path.close();
                canvas.drawPath(path, this.mPaint);
                break;
            }
            case SHAPE_RECT: {
                if (this.mIsLoading) {
                    this.mAnimPercent = (float)((double)this.mAnimPercent + 0.15);
                    if (this.mAnimPercent >= 1.0f) {
                        this.mShape = Shape.SHAPE_TRIANGLE;
                        this.mIsLoading = false;
                        this.mAnimPercent = 1.0f;
                    }
                    int color4 = (Integer)this.mArgbEvaluator.evaluate(this.mAnimPercent, (Object)this.mRectColor, (Object)this.mTriangleColor);
                    this.mPaint.setColor(color4);
                    Path path = new Path();
                    path.moveTo(this.relativeXFromView(0.5f * this.mAnimPercent), 0.0f);
                    path.lineTo(this.relativeYFromView(1.0f - 0.5f * this.mAnimPercent), 0.0f);
                    float distanceX = this.mControlX * this.mAnimPercent;
                    float distanceY = (this.relativeYFromView(1.0f) - this.mControlY) * this.mAnimPercent;
                    path.lineTo(this.relativeXFromView(1.0f) - distanceX, this.relativeYFromView(1.0f) - distanceY);
                    path.lineTo(this.relativeXFromView(0.0f) + distanceX, this.relativeYFromView(1.0f) - distanceY);
                    path.close();
                    canvas.drawPath(path, this.mPaint);
                    this.invalidate();
                    break;
                }
                this.mPaint.setColor(this.getResources().getColor(R.color.rect));
                this.mControlX = this.relativeXFromView(0.066987306f);
                this.mControlY = this.relativeYFromView(0.75f);
                Path path = new Path();
                path.moveTo(this.relativeXFromView(0.0f), this.relativeYFromView(0.0f));
                path.lineTo(this.relativeXFromView(1.0f), this.relativeYFromView(0.0f));
                path.lineTo(this.relativeXFromView(1.0f), this.relativeYFromView(1.0f));
                path.lineTo(this.relativeXFromView(0.0f), this.relativeYFromView(1.0f));
                path.close();
                this.mAnimPercent = 0.0f;
                canvas.drawPath(path, this.mPaint);
            }
        }
    }

    private float relativeXFromView(float percent) {
        return (float)this.getWidth() * percent;
    }

    private float relativeYFromView(float percent) {
        return (float)this.getHeight() * percent;
    }

    public void changeShape() {
        this.mIsLoading = true;
        this.invalidate();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.invalidate();
        }
    }

    public Shape getShape() {
        return this.mShape;
    }

    public static enum Shape {
        SHAPE_TRIANGLE,
        SHAPE_RECT,
        SHAPE_CIRCLE;

    }
}

