/*
 * Decompiled with CFR 0.152.
 */
package com.mingle.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.mingle.shapeloading.R;
import com.mingle.widget.ShapeLoadingView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;

public class LoadingView
extends FrameLayout {
    private static final int ANIMATION_DURATION = 500;
    private static float mDistance = 200.0f;
    private ShapeLoadingView mShapeLoadingView;
    private ImageView mIndicationIm;
    private TextView mLoadTextView;
    private int mTextAppearance;
    private String mLoadText;
    private AnimatorSet mAnimatorSet = null;
    private Runnable mFreeFallRunnable = new Runnable(){

        @Override
        public void run() {
            LoadingView.this.freeFall();
        }
    };
    public float factor = 1.2f;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
        this.mLoadText = typedArray.getString(R.styleable.LoadingView_loadingText);
        this.mTextAppearance = typedArray.getResourceId(R.styleable.LoadingView_loadingTextAppearance, -1);
        typedArray.recycle();
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public int dip2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.load_view, null);
        mDistance = this.dip2px(54.0f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.mShapeLoadingView = (ShapeLoadingView)view.findViewById(R.id.shapeLoadingView);
        this.mIndicationIm = (ImageView)view.findViewById(R.id.indication);
        this.mLoadTextView = (TextView)view.findViewById(R.id.promptTV);
        if (this.mTextAppearance != -1) {
            this.mLoadTextView.setTextAppearance(this.getContext(), this.mTextAppearance);
        }
        this.setLoadingText(this.mLoadText);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
        this.startLoading(900L);
    }

    private void startLoading(long delay) {
        if (this.mAnimatorSet != null && this.mAnimatorSet.isRunning()) {
            return;
        }
        this.removeCallbacks(this.mFreeFallRunnable);
        if (delay > 0L) {
            this.postDelayed(this.mFreeFallRunnable, delay);
        } else {
            this.post(this.mFreeFallRunnable);
        }
    }

    private void stopLoading() {
        if (this.mAnimatorSet != null) {
            if (this.mAnimatorSet.isRunning()) {
                this.mAnimatorSet.cancel();
            }
            this.mAnimatorSet = null;
        }
        this.removeCallbacks(this.mFreeFallRunnable);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.startLoading(200L);
        } else {
            this.stopLoading();
        }
    }

    public void setLoadingText(CharSequence loadingText) {
        if (TextUtils.isEmpty((CharSequence)loadingText)) {
            this.mLoadTextView.setVisibility(8);
        } else {
            this.mLoadTextView.setVisibility(0);
        }
        this.mLoadTextView.setText(loadingText);
    }

    public void upThrow() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mShapeLoadingView), (String)"translationY", (float[])new float[]{mDistance, 0.0f});
        ObjectAnimator scaleIndication = ObjectAnimator.ofFloat((Object)this.mIndicationIm, (String)"scaleX", (float[])new float[]{0.2f, 1.0f});
        ObjectAnimator objectAnimator1 = null;
        switch (this.mShapeLoadingView.getShape()) {
            case SHAPE_RECT: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mShapeLoadingView), (String)"rotation", (float[])new float[]{0.0f, -120.0f});
                break;
            }
            case SHAPE_CIRCLE: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mShapeLoadingView), (String)"rotation", (float[])new float[]{0.0f, 180.0f});
                break;
            }
            case SHAPE_TRIANGLE: {
                objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this.mShapeLoadingView), (String)"rotation", (float[])new float[]{0.0f, 180.0f});
            }
        }
        objectAnimator.setDuration(500L);
        objectAnimator1.setDuration(500L);
        objectAnimator.setInterpolator((Interpolator)new DecelerateInterpolator(this.factor));
        objectAnimator1.setInterpolator((Interpolator)new DecelerateInterpolator(this.factor));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(500L);
        animatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator1, scaleIndication});
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                LoadingView.this.freeFall();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }

    public void freeFall() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mShapeLoadingView), (String)"translationY", (float[])new float[]{0.0f, mDistance});
        ObjectAnimator scaleIndication = ObjectAnimator.ofFloat((Object)this.mIndicationIm, (String)"scaleX", (float[])new float[]{1.0f, 0.2f});
        objectAnimator.setDuration(500L);
        objectAnimator.setInterpolator((Interpolator)new AccelerateInterpolator(this.factor));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(500L);
        animatorSet.playTogether(new Animator[]{objectAnimator, scaleIndication});
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                LoadingView.this.mShapeLoadingView.changeShape();
                LoadingView.this.upThrow();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }
}

