/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.popup;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.support.v4.widget.PopupWindowCompat;
import android.transition.Transition;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;

public abstract class BasePopup<T extends BasePopup>
implements PopupWindow.OnDismissListener {
    private static final String TAG = "EasyPopup";
    private static final float DEFAULT_DIM = 0.7f;
    private PopupWindow mPopupWindow;
    private Context mContext;
    private View mContentView;
    private int mLayoutId;
    private boolean mFocusable = true;
    private boolean mOutsideTouchable = true;
    private int mWidth = -2;
    private int mHeight = -2;
    private int mAnimationStyle;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private boolean isBackgroundDim;
    private float mDimValue = 0.7f;
    @ColorInt
    private int mDimColor = -16777216;
    @NonNull
    private ViewGroup mDimView;
    private Transition mEnterTransition;
    private Transition mExitTransition;
    private boolean mFocusAndOutsideEnable = true;
    private View mAnchorView;
    private int mYGravity = 2;
    private int mXGravity = 1;
    private int mOffsetX;
    private int mOffsetY;
    private int mInputMethodMode = 0;
    private int mSoftInputMode = 1;
    private boolean isNeedReMeasureWH = false;
    private boolean isRealWHAlready = false;
    private boolean isAtAnchorViewMethod = false;
    private OnRealWHAlreadyListener mOnRealWHAlreadyListener;

    protected T self() {
        return (T)this;
    }

    public T apply() {
        if (this.mPopupWindow == null) {
            this.mPopupWindow = new PopupWindow();
        }
        this.onPopupWindowCreated();
        this.initContentViewAndWH();
        this.onPopupWindowViewCreated(this.mContentView);
        if (this.mAnimationStyle != 0) {
            this.mPopupWindow.setAnimationStyle(this.mAnimationStyle);
        }
        this.initFocusAndBack();
        this.mPopupWindow.setOnDismissListener((PopupWindow.OnDismissListener)this);
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.mEnterTransition != null) {
                this.mPopupWindow.setEnterTransition(this.mEnterTransition);
            }
            if (this.mExitTransition != null) {
                this.mPopupWindow.setExitTransition(this.mExitTransition);
            }
        }
        return this.self();
    }

    private void initContentViewAndWH() {
        if (this.mContentView == null) {
            if (this.mLayoutId != 0 && this.mContext != null) {
                this.mContentView = LayoutInflater.from((Context)this.mContext).inflate(this.mLayoutId, null);
            } else {
                throw new IllegalArgumentException("The content view is null,the layoutId=" + this.mLayoutId + ",context=" + this.mContext);
            }
        }
        this.mPopupWindow.setContentView(this.mContentView);
        if (this.mWidth > 0 || this.mWidth == -2 || this.mWidth == -1) {
            this.mPopupWindow.setWidth(this.mWidth);
        } else {
            this.mPopupWindow.setWidth(-2);
        }
        if (this.mHeight > 0 || this.mHeight == -2 || this.mHeight == -1) {
            this.mPopupWindow.setHeight(this.mHeight);
        } else {
            this.mPopupWindow.setHeight(-2);
        }
        this.measureContentView();
        this.registerOnGlobalLayoutListener();
        this.mPopupWindow.setInputMethodMode(this.mInputMethodMode);
        this.mPopupWindow.setSoftInputMode(this.mSoftInputMode);
    }

    private void initFocusAndBack() {
        if (!this.mFocusAndOutsideEnable) {
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(false);
            this.mPopupWindow.setBackgroundDrawable(null);
            this.mPopupWindow.getContentView().setFocusable(true);
            this.mPopupWindow.getContentView().setFocusableInTouchMode(true);
            this.mPopupWindow.getContentView().setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        BasePopup.this.mPopupWindow.dismiss();
                        return true;
                    }
                    return false;
                }
            });
            this.mPopupWindow.setTouchInterceptor(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    if (event.getAction() == 0 && (x < 0 || x >= BasePopup.this.mWidth || y < 0 || y >= BasePopup.this.mHeight)) {
                        Log.d((String)BasePopup.TAG, (String)("onTouch outside:mWidth=" + BasePopup.this.mWidth + ",mHeight=" + BasePopup.this.mHeight));
                        return true;
                    }
                    if (event.getAction() == 4) {
                        Log.d((String)BasePopup.TAG, (String)("onTouch outside event:mWidth=" + BasePopup.this.mWidth + ",mHeight=" + BasePopup.this.mHeight));
                        return true;
                    }
                    return false;
                }
            });
        } else {
            this.mPopupWindow.setFocusable(this.mFocusable);
            this.mPopupWindow.setOutsideTouchable(this.mOutsideTouchable);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    protected void onPopupWindowCreated() {
        this.initAttributes();
    }

    protected void onPopupWindowViewCreated(View contentView) {
        this.initViews(contentView);
    }

    protected void onPopupWindowDismiss() {
    }

    protected abstract void initAttributes();

    protected abstract void initViews(View var1);

    private void measureContentView() {
        View contentView = this.getContentView();
        if (this.mWidth <= 0 || this.mHeight <= 0) {
            contentView.measure(0, 0);
            if (this.mWidth <= 0) {
                this.mWidth = contentView.getMeasuredWidth();
            }
            if (this.mHeight <= 0) {
                this.mHeight = contentView.getMeasuredHeight();
            }
        }
    }

    private void registerOnGlobalLayoutListener() {
        this.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                BasePopup.this.getContentView().getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                BasePopup.this.mWidth = BasePopup.this.getContentView().getWidth();
                BasePopup.this.mHeight = BasePopup.this.getContentView().getHeight();
                BasePopup.this.isRealWHAlready = true;
                BasePopup.this.isNeedReMeasureWH = false;
                if (BasePopup.this.mOnRealWHAlreadyListener != null) {
                    BasePopup.this.mOnRealWHAlreadyListener.onRealWHAlready(BasePopup.this, BasePopup.this.mWidth, BasePopup.this.mHeight, BasePopup.this.mAnchorView == null ? 0 : BasePopup.this.mAnchorView.getWidth(), BasePopup.this.mAnchorView == null ? 0 : BasePopup.this.mAnchorView.getHeight());
                }
                if (BasePopup.this.isShowing() && BasePopup.this.isAtAnchorViewMethod) {
                    BasePopup.this.updateLocation(BasePopup.this.mWidth, BasePopup.this.mHeight, BasePopup.this.mAnchorView, BasePopup.this.mYGravity, BasePopup.this.mXGravity, BasePopup.this.mOffsetX, BasePopup.this.mOffsetY);
                }
            }
        });
    }

    private void updateLocation(int width, int height, @NonNull View anchor, int yGravity, int xGravity, int x, int y) {
        if (this.mPopupWindow == null) {
            return;
        }
        x = this.calculateX(anchor, xGravity, width, x);
        y = this.calculateY(anchor, yGravity, height, y);
        this.mPopupWindow.update(anchor, x, y, width, height);
    }

    public T setContext(Context context) {
        this.mContext = context;
        return this.self();
    }

    public T setContentView(View contentView) {
        this.mContentView = contentView;
        this.mLayoutId = 0;
        return this.self();
    }

    public T setContentView(@LayoutRes int layoutId) {
        this.mContentView = null;
        this.mLayoutId = layoutId;
        return this.self();
    }

    public T setContentView(Context context, @LayoutRes int layoutId) {
        this.mContext = context;
        this.mContentView = null;
        this.mLayoutId = layoutId;
        return this.self();
    }

    public T setContentView(View contentView, int width, int height) {
        this.mContentView = contentView;
        this.mLayoutId = 0;
        this.mWidth = width;
        this.mHeight = height;
        return this.self();
    }

    public T setContentView(@LayoutRes int layoutId, int width, int height) {
        this.mContentView = null;
        this.mLayoutId = layoutId;
        this.mWidth = width;
        this.mHeight = height;
        return this.self();
    }

    public T setContentView(Context context, @LayoutRes int layoutId, int width, int height) {
        this.mContext = context;
        this.mContentView = null;
        this.mLayoutId = layoutId;
        this.mWidth = width;
        this.mHeight = height;
        return this.self();
    }

    public T setWidth(int width) {
        this.mWidth = width;
        return this.self();
    }

    public T setHeight(int height) {
        this.mHeight = height;
        return this.self();
    }

    public T setAnchorView(View view) {
        this.mAnchorView = view;
        return this.self();
    }

    public T setYGravity(int yGravity) {
        this.mYGravity = yGravity;
        return this.self();
    }

    public T setXGravity(int xGravity) {
        this.mXGravity = xGravity;
        return this.self();
    }

    public T setOffsetX(int offsetX) {
        this.mOffsetX = offsetX;
        return this.self();
    }

    public T setOffsetY(int offsetY) {
        this.mOffsetY = offsetY;
        return this.self();
    }

    public T setAnimationStyle(@StyleRes int animationStyle) {
        this.mAnimationStyle = animationStyle;
        return this.self();
    }

    public T setFocusable(boolean focusable) {
        this.mFocusable = focusable;
        return this.self();
    }

    public T setOutsideTouchable(boolean outsideTouchable) {
        this.mOutsideTouchable = outsideTouchable;
        return this.self();
    }

    public T setFocusAndOutsideEnable(boolean focusAndOutsideEnable) {
        this.mFocusAndOutsideEnable = focusAndOutsideEnable;
        return this.self();
    }

    public T setBackgroundDimEnable(boolean isDim) {
        this.isBackgroundDim = isDim;
        return this.self();
    }

    public T setDimValue(@FloatRange(from=0.0, to=1.0) float dimValue) {
        this.mDimValue = dimValue;
        return this.self();
    }

    public T setDimColor(@ColorInt int color) {
        this.mDimColor = color;
        return this.self();
    }

    public T setDimView(@NonNull ViewGroup dimView) {
        this.mDimView = dimView;
        return this.self();
    }

    @RequiresApi(api=23)
    public T setEnterTransition(Transition enterTransition) {
        this.mEnterTransition = enterTransition;
        return this.self();
    }

    @RequiresApi(api=23)
    public T setExitTransition(Transition exitTransition) {
        this.mExitTransition = exitTransition;
        return this.self();
    }

    public T setInputMethodMode(int mode) {
        this.mInputMethodMode = mode;
        return this.self();
    }

    public T setSoftInputMode(int mode) {
        this.mSoftInputMode = mode;
        return this.self();
    }

    public T setNeedReMeasureWH(boolean needReMeasureWH) {
        this.isNeedReMeasureWH = needReMeasureWH;
        return this.self();
    }

    private void checkIsApply(boolean isAtAnchorView) {
        if (this.isAtAnchorViewMethod != isAtAnchorView) {
            this.isAtAnchorViewMethod = isAtAnchorView;
        }
        if (this.mPopupWindow == null) {
            this.apply();
        }
    }

    public void showAsDropDown() {
        if (this.mAnchorView == null) {
            return;
        }
        this.showAsDropDown(this.mAnchorView, this.mOffsetX, this.mOffsetY);
    }

    public void showAsDropDown(View anchor, int offsetX, int offsetY) {
        this.checkIsApply(false);
        this.handleBackgroundDim();
        this.mAnchorView = anchor;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        if (this.isNeedReMeasureWH) {
            this.registerOnGlobalLayoutListener();
        }
        this.mPopupWindow.showAsDropDown(anchor, this.mOffsetX, this.mOffsetY);
    }

    public void showAsDropDown(View anchor) {
        this.checkIsApply(false);
        this.handleBackgroundDim();
        this.mAnchorView = anchor;
        if (this.isNeedReMeasureWH) {
            this.registerOnGlobalLayoutListener();
        }
        this.mPopupWindow.showAsDropDown(anchor);
    }

    @RequiresApi(api=19)
    public void showAsDropDown(View anchor, int offsetX, int offsetY, int gravity) {
        this.checkIsApply(false);
        this.handleBackgroundDim();
        this.mAnchorView = anchor;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        if (this.isNeedReMeasureWH) {
            this.registerOnGlobalLayoutListener();
        }
        PopupWindowCompat.showAsDropDown((PopupWindow)this.mPopupWindow, (View)anchor, (int)this.mOffsetX, (int)this.mOffsetY, (int)gravity);
    }

    public void showAtLocation(View parent, int gravity, int offsetX, int offsetY) {
        this.checkIsApply(false);
        this.handleBackgroundDim();
        this.mAnchorView = parent;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        if (this.isNeedReMeasureWH) {
            this.registerOnGlobalLayoutListener();
        }
        this.mPopupWindow.showAtLocation(parent, gravity, this.mOffsetX, this.mOffsetY);
    }

    public void showAtAnchorView() {
        if (this.mAnchorView == null) {
            return;
        }
        this.showAtAnchorView(this.mAnchorView, this.mYGravity, this.mXGravity);
    }

    public void showAtAnchorView(@NonNull View anchor, int vertGravity, int horizGravity) {
        this.showAtAnchorView(anchor, vertGravity, horizGravity, 0, 0);
    }

    public void showAtAnchorView(@NonNull View anchor, int vertGravity, int horizGravity, int x, int y) {
        this.checkIsApply(true);
        this.mAnchorView = anchor;
        this.mOffsetX = x;
        this.mOffsetY = y;
        this.mYGravity = vertGravity;
        this.mXGravity = horizGravity;
        this.handleBackgroundDim();
        x = this.calculateX(anchor, horizGravity, this.mWidth, this.mOffsetX);
        y = this.calculateY(anchor, vertGravity, this.mHeight, this.mOffsetY);
        if (this.isNeedReMeasureWH) {
            this.registerOnGlobalLayoutListener();
        }
        PopupWindowCompat.showAsDropDown((PopupWindow)this.mPopupWindow, (View)anchor, (int)x, (int)y, (int)0);
    }

    private int calculateY(View anchor, int vertGravity, int measuredH, int y) {
        switch (vertGravity) {
            case 1: {
                y -= measuredH + anchor.getHeight();
                break;
            }
            case 4: {
                y -= measuredH;
                break;
            }
            case 0: {
                y -= anchor.getHeight() / 2 + measuredH / 2;
                break;
            }
            case 3: {
                y -= anchor.getHeight();
                break;
            }
        }
        return y;
    }

    private int calculateX(View anchor, int horizGravity, int measuredW, int x) {
        switch (horizGravity) {
            case 1: {
                x -= measuredW;
                break;
            }
            case 4: {
                x -= measuredW - anchor.getWidth();
                break;
            }
            case 0: {
                x += anchor.getWidth() / 2 - measuredW / 2;
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                x += anchor.getWidth();
            }
        }
        return x;
    }

    public T setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
        return this.self();
    }

    public T setOnRealWHAlreadyListener(OnRealWHAlreadyListener listener) {
        this.mOnRealWHAlreadyListener = listener;
        return this.self();
    }

    private void handleBackgroundDim() {
        if (Build.VERSION.SDK_INT >= 18) {
            if (!this.isBackgroundDim) {
                return;
            }
            if (this.mDimView != null) {
                this.applyDim(this.mDimView);
            } else if (this.getContentView() != null && this.getContentView().getContext() != null && this.getContentView().getContext() instanceof Activity) {
                Activity activity = (Activity)this.getContentView().getContext();
                this.applyDim(activity);
            }
        }
    }

    @RequiresApi(api=18)
    private void applyDim(Activity activity) {
        ViewGroup parent = (ViewGroup)activity.getWindow().getDecorView().getRootView();
        ColorDrawable dimDrawable = new ColorDrawable(this.mDimColor);
        dimDrawable.setBounds(0, 0, parent.getWidth(), parent.getHeight());
        dimDrawable.setAlpha((int)(255.0f * this.mDimValue));
        ViewGroupOverlay overlay = parent.getOverlay();
        overlay.add((Drawable)dimDrawable);
    }

    @RequiresApi(api=18)
    private void applyDim(ViewGroup dimView) {
        ColorDrawable dimDrawable = new ColorDrawable(this.mDimColor);
        dimDrawable.setBounds(0, 0, dimView.getWidth(), dimView.getHeight());
        dimDrawable.setAlpha((int)(255.0f * this.mDimValue));
        ViewGroupOverlay overlay = dimView.getOverlay();
        overlay.add((Drawable)dimDrawable);
    }

    private void clearBackgroundDim() {
        if (Build.VERSION.SDK_INT >= 18 && this.isBackgroundDim) {
            Activity activity;
            if (this.mDimView != null) {
                this.clearDim(this.mDimView);
            } else if (this.getContentView() != null && (activity = (Activity)this.getContentView().getContext()) != null) {
                this.clearDim(activity);
            }
        }
    }

    @RequiresApi(api=18)
    private void clearDim(Activity activity) {
        ViewGroup parent = (ViewGroup)activity.getWindow().getDecorView().getRootView();
        ViewGroupOverlay overlay = parent.getOverlay();
        overlay.clear();
    }

    @RequiresApi(api=18)
    private void clearDim(ViewGroup dimView) {
        ViewGroupOverlay overlay = dimView.getOverlay();
        overlay.clear();
    }

    public View getContentView() {
        if (this.mPopupWindow != null) {
            return this.mPopupWindow.getContentView();
        }
        return null;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getXGravity() {
        return this.mXGravity;
    }

    public int getYGravity() {
        return this.mYGravity;
    }

    public int getOffsetX() {
        return this.mOffsetX;
    }

    public int getOffsetY() {
        return this.mOffsetY;
    }

    public boolean isShowing() {
        return this.mPopupWindow != null && this.mPopupWindow.isShowing();
    }

    public boolean isRealWHAlready() {
        return this.isRealWHAlready;
    }

    public <T extends View> T findViewById(@IdRes int viewId) {
        View view = null;
        if (this.getContentView() != null) {
            view = this.getContentView().findViewById(viewId);
        }
        return (T)view;
    }

    public void dismiss() {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
    }

    public void onDismiss() {
        this.handleDismiss();
    }

    private void handleDismiss() {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
        this.clearBackgroundDim();
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
        this.onPopupWindowDismiss();
    }

    public static interface OnRealWHAlreadyListener {
        public void onRealWHAlready(BasePopup var1, int var2, int var3, int var4, int var5);
    }
}

