/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.components.scansurface;

import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.common.extensions.ImageProxyExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.ImageDetectionProperties;
import com.zynksoftware.documentscanner.common.utils.OpenCvNativeBridge;
import com.zynksoftware.documentscanner.model.DocumentScannerErrorModel;
import com.zynksoftware.documentscanner.ui.components.Quadrilateral;
import com.zynksoftware.documentscanner.ui.components.ScanCanvasView;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceListener;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceView;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J\b\u0010<\u001a\u000209H\u0002J\b\u0010=\u001a\u000209H\u0002J+\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020EH\u0002\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u000209H\u0002J\b\u0010H\u001a\u000209H\u0002J\b\u0010I\u001a\u000209H\u0002J\b\u0010J\u001a\u000209H\u0002J\u0006\u0010K\u001a\u000209J\u0006\u0010L\u001a\u000209J\u0006\u0010M\u001a\u000209J\u0006\u0010N\u001a\u000209R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoCaptureTimer", "Landroid/os/CountDownTimer;", "camera", "Landroidx/camera/core/Camera;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "flashMode", "imageAnalysis", "Landroidx/camera/core/ImageAnalysis;", "imageCapture", "Landroidx/camera/core/ImageCapture;", "isAutoCaptureOn", "", "()Z", "setAutoCaptureOn", "(Z)V", "isAutoCaptureScheduled", "isCapturing", "isFlashEnabled", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "setLifecycleOwner", "(Landroidx/lifecycle/LifecycleOwner;)V", "listener", "Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "getListener", "()Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "setListener", "(Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;)V", "millisLeft", "", "nativeClass", "Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge;", "originalImageFile", "Ljava/io/File;", "getOriginalImageFile", "()Ljava/io/File;", "setOriginalImageFile", "(Ljava/io/File;)V", "preview", "Landroidx/camera/core/Preview;", "previewSize", "Landroid/util/Size;", "autoCapture", "", "bindCamera", "cancelAutoCapture", "checkIfFlashIsPresent", "clearAndInvalidateCanvas", "drawLargestRect", "approx", "Lorg/opencv/core/MatOfPoint2f;", "points", "", "Lorg/opencv/core/Point;", "stdSize", "Lorg/opencv/core/Size;", "(Lorg/opencv/core/MatOfPoint2f;[Lorg/opencv/core/Point;Lorg/opencv/core/Size;)V", "openCamera", "scheduleAutoCapture", "setImageCapture", "setUseCases", "start", "switchFlashState", "takePicture", "unbindCamera", "Companion", "DocumentScanner_release"})
public final class ScanSurfaceView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public LifecycleOwner lifecycleOwner;
    public ScanSurfaceListener listener;
    public File originalImageFile;
    @NotNull
    private final OpenCvNativeBridge nativeClass;
    @Nullable
    private CountDownTimer autoCaptureTimer;
    private long millisLeft;
    private boolean isAutoCaptureScheduled;
    private boolean isCapturing;
    @Nullable
    private ImageAnalysis imageAnalysis;
    @Nullable
    private Camera camera;
    @Nullable
    private ImageCapture imageCapture;
    @Nullable
    private Preview preview;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    private Size previewSize;
    private boolean isAutoCaptureOn;
    private boolean isFlashEnabled;
    private int flashMode;
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(ScanSurfaceView.class).getSimpleName();
    private static final long TIME_POST_PICTURE = 1500L;
    private static final long DEFAULT_TIME_POST_PICTURE = 1500L;
    private static final int IMAGE_ANALYSIS_SCALE_WIDTH = 400;

    public ScanSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
        this._$_findViewCache = new LinkedHashMap();
    }

    public ScanSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
        this._$_findViewCache = new LinkedHashMap();
    }

    public ScanSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
        this._$_findViewCache = new LinkedHashMap();
    }

    @NotNull
    public final LifecycleOwner getLifecycleOwner() {
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        if (lifecycleOwner != null) {
            return lifecycleOwner;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleOwner");
        return null;
    }

    public final void setLifecycleOwner(@NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"<set-?>");
        this.lifecycleOwner = lifecycleOwner;
    }

    @NotNull
    public final ScanSurfaceListener getListener() {
        ScanSurfaceListener scanSurfaceListener = this.listener;
        if (scanSurfaceListener != null) {
            return scanSurfaceListener;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        return null;
    }

    public final void setListener(@NotNull ScanSurfaceListener scanSurfaceListener) {
        Intrinsics.checkNotNullParameter((Object)scanSurfaceListener, (String)"<set-?>");
        this.listener = scanSurfaceListener;
    }

    @NotNull
    public final File getOriginalImageFile() {
        File file = this.originalImageFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"originalImageFile");
        return null;
    }

    public final void setOriginalImageFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.originalImageFile = file;
    }

    public final boolean isAutoCaptureOn() {
        return this.isAutoCaptureOn;
    }

    public final void setAutoCaptureOn(boolean bl) {
        this.isAutoCaptureOn = bl;
    }

    public final void start() {
        ((PreviewView)this._$_findCachedViewById(R.id.viewFinder)).post(() -> ScanSurfaceView.start$lambda-0(this));
    }

    private final void clearAndInvalidateCanvas() {
        ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).clearShape();
    }

    private final void openCamera() {
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getInstance(context)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(() -> ScanSurfaceView.openCamera$lambda-1(this, cameraProviderFuture), ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    private final void bindCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        this.camera = null;
        this.setUseCases();
    }

    private final void setImageCapture() {
        if (this.imageCapture != null) {
            boolean bl;
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider == null) {
                bl = false;
            } else {
                ImageCapture imageCapture = this.imageCapture;
                Intrinsics.checkNotNull((Object)imageCapture);
                bl = processCameraProvider.isBound((UseCase)imageCapture);
            }
            if (bl) {
                ProcessCameraProvider processCameraProvider2 = this.cameraProvider;
                if (processCameraProvider2 != null) {
                    UseCase[] useCaseArray = new UseCase[]{(UseCase)this.imageCapture};
                    processCameraProvider2.unbind(useCaseArray);
                }
            }
        }
        this.imageCapture = null;
        this.imageCapture = new ImageCapture.Builder().setFlashMode(this.flashMode).build();
    }

    public final void unbindCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            UseCase[] useCaseArray = new UseCase[]{(UseCase)this.imageAnalysis};
            processCameraProvider.unbind(useCaseArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUseCases() {
        void it;
        Preview preview;
        Preview.Builder builder = new Preview.Builder();
        Size size = this.previewSize;
        if (size == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
            size = null;
        }
        Preview preview2 = preview = builder.setTargetResolution(size).build();
        ScanSurfaceView scanSurfaceView = this;
        boolean bl = false;
        it.setSurfaceProvider(((PreviewView)this._$_findCachedViewById(R.id.viewFinder)).getSurfaceProvider());
        scanSurfaceView.preview = preview;
        this.setImageCapture();
        Size size2 = this.previewSize;
        if (size2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
            size2 = null;
        }
        float f = size2.getWidth();
        Size size3 = this.previewSize;
        if (size3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
            size3 = null;
        }
        float aspectRatio = f / (float)size3.getHeight();
        int width = 400;
        int height = MathKt.roundToInt((float)((float)width / aspectRatio));
        ImageAnalysis imageAnalysis = this.imageAnalysis = new ImageAnalysis.Builder().setBackpressureStrategy(0).setTargetResolution(new Size(width, height)).build();
        if (imageAnalysis != null) {
            imageAnalysis.setAnalyzer(ContextCompat.getMainExecutor((Context)this.getContext()), arg_0 -> ScanSurfaceView.setUseCases$lambda-3(this, arg_0));
        }
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        Intrinsics.checkNotNull((Object)processCameraProvider);
        UseCase[] useCaseArray = new UseCase[]{(UseCase)this.preview, (UseCase)this.imageAnalysis, (UseCase)this.imageCapture};
        this.camera = processCameraProvider.bindToLifecycle(this.getLifecycleOwner(), CameraSelector.DEFAULT_BACK_CAMERA, useCaseArray);
    }

    private final void drawLargestRect(MatOfPoint2f approx, Point[] points, org.opencv.core.Size stdSize) {
        float resultHeight;
        float previewWidth = (float)stdSize.height;
        float previewHeight = (float)stdSize.width;
        float resultWidth = Math.max(previewWidth - (float)points[0].y, previewWidth - (float)points[1].y) - Math.min(previewWidth - (float)points[2].y, previewWidth - (float)points[3].y);
        ImageDetectionProperties imgDetectionPropsObj = new ImageDetectionProperties(previewWidth, previewHeight, points[0], points[1], points[2], points[3], (int)resultWidth, (int)(resultHeight = Math.max((float)points[1].x, (float)points[2].x) - Math.min((float)points[0].x, (float)points[3].x)));
        if (imgDetectionPropsObj.isNotValidImage(approx)) {
            ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).clearShape();
            this.cancelAutoCapture();
        } else {
            if (!this.isAutoCaptureScheduled) {
                this.scheduleAutoCapture();
            }
            ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).showShape(previewWidth, previewHeight, points);
        }
    }

    private final void scheduleAutoCapture() {
        this.isAutoCaptureScheduled = true;
        this.millisLeft = 0L;
        CountDownTimer countDownTimer = this.autoCaptureTimer = (CountDownTimer)new CountDownTimer(this){
            final /* synthetic */ ScanSurfaceView this$0;
            {
                this.this$0 = $receiver;
                super(1500L, 100L);
            }

            public void onTick(long millisUntilFinished) {
                if (millisUntilFinished != ScanSurfaceView.access$getMillisLeft$p(this.this$0)) {
                    ScanSurfaceView.access$setMillisLeft$p(this.this$0, millisUntilFinished);
                }
            }

            public void onFinish() {
                ScanSurfaceView.access$setAutoCaptureScheduled$p(this.this$0, false);
                ScanSurfaceView.access$autoCapture(this.this$0);
            }
        };
        if (countDownTimer != null) {
            countDownTimer.start();
        }
    }

    private final void autoCapture() {
        if (this.isCapturing) {
            return;
        }
        this.cancelAutoCapture();
        this.takePicture();
    }

    public final void takePicture() {
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"ZDCtakePicture Starts ", (Object)System.currentTimeMillis()));
        this.getListener().scanSurfaceShowProgress();
        this.isCapturing = true;
        ImageCapture imageCapture = this.imageCapture;
        if (imageCapture == null) {
            return;
        }
        ImageCapture imageCapture2 = imageCapture;
        ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(this.getOriginalImageFile()).build();
        Intrinsics.checkNotNullExpressionValue((Object)outputFileOptions, (String)"Builder(originalImageFile).build()");
        ImageCapture.OutputFileOptions outputOptions = outputFileOptions;
        imageCapture2.takePicture(outputOptions, ContextCompat.getMainExecutor((Context)this.getContext()), new ImageCapture.OnImageSavedCallback(this){
            final /* synthetic */ ScanSurfaceView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull ImageCaptureException exc) {
                Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                this.this$0.getListener().scanSurfaceHideProgress();
                Log.e((String)ScanSurfaceView.access$getTAG$cp(), (String)(DocumentScannerErrorModel.ErrorMessage.PHOTO_CAPTURE_FAILED.getError() + ": " + exc.getMessage()), (Throwable)((Throwable)exc));
                this.this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.PHOTO_CAPTURE_FAILED, (Throwable)exc));
            }

            public void onImageSaved(@NotNull ImageCapture.OutputFileResults output) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                this.this$0.getListener().scanSurfaceHideProgress();
                this.this$0.unbindCamera();
                ScanSurfaceView.access$clearAndInvalidateCanvas(this.this$0);
                this.this$0.getListener().scanSurfacePictureTaken();
                this.this$0.postDelayed(() -> takePicture.1.onImageSaved$lambda-0(this.this$0), 1500L);
                Log.d((String)ScanSurfaceView.access$getTAG$cp(), (String)Intrinsics.stringPlus((String)"ZDCtakePicture ends ", (Object)System.currentTimeMillis()));
            }

            private static final void onImageSaved$lambda-0(ScanSurfaceView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                ScanSurfaceView.access$setCapturing$p(this$0, false);
            }
        });
    }

    private final void checkIfFlashIsPresent() {
        boolean bl;
        Camera camera = this.camera;
        if (camera == null) {
            bl = false;
        } else {
            CameraInfo cameraInfo = camera.getCameraInfo();
            bl = cameraInfo == null ? false : cameraInfo.hasFlashUnit();
        }
        if (bl) {
            this.getListener().showFlash();
        } else {
            this.getListener().hideFlash();
        }
    }

    private final void cancelAutoCapture() {
        if (this.isAutoCaptureScheduled) {
            this.isAutoCaptureScheduled = false;
            CountDownTimer countDownTimer = this.autoCaptureTimer;
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
        }
    }

    public final void switchFlashState() {
        int n;
        boolean bl = this.isFlashEnabled = !this.isFlashEnabled;
        if (this.isFlashEnabled) {
            this.getListener().showFlashModeOn();
            n = 1;
        } else {
            this.getListener().showFlashModeOff();
            n = 2;
        }
        this.flashMode = n;
        this.setImageCapture();
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        Intrinsics.checkNotNull((Object)processCameraProvider);
        UseCase[] useCaseArray = new UseCase[]{(UseCase)this.imageCapture};
        this.camera = processCameraProvider.bindToLifecycle(this.getLifecycleOwner(), CameraSelector.DEFAULT_BACK_CAMERA, useCaseArray);
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    private static final void start$lambda-0(ScanSurfaceView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ((PreviewView)this$0._$_findCachedViewById(R.id.viewFinder)).measure(0, 0);
        this$0.previewSize = new Size(((PreviewView)this$0._$_findCachedViewById(R.id.viewFinder)).getWidth(), ((PreviewView)this$0._$_findCachedViewById(R.id.viewFinder)).getHeight());
        this$0.openCamera();
    }

    private static final void openCamera$lambda-1(ScanSurfaceView this$0, ListenableFuture $cameraProviderFuture) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraProviderFuture, (String)"$cameraProviderFuture");
        this$0.cameraProvider = (ProcessCameraProvider)$cameraProviderFuture.get();
        try {
            this$0.bindCamera();
            this$0.checkIfFlashIsPresent();
        }
        catch (Exception exc) {
            Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.CAMERA_USE_CASE_BINDING_FAILED.getError(), (Throwable)exc);
            this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_USE_CASE_BINDING_FAILED, exc));
        }
    }

    private static final void setUseCases$lambda-3(ScanSurfaceView this$0, ImageProxy image) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            if (this$0.isAutoCaptureOn) {
                try {
                    Mat mat = ImageProxyExtensionsKt.yuvToRgba(image);
                    org.opencv.core.Size originalPreviewSize = mat.size();
                    Quadrilateral largestQuad = this$0.nativeClass.detectLargestQuadrilateral(mat);
                    mat.release();
                    if (largestQuad != null) {
                        MatOfPoint2f matOfPoint2f = largestQuad.getContour();
                        Point[] pointArray = largestQuad.getPoints();
                        Intrinsics.checkNotNullExpressionValue((Object)originalPreviewSize, (String)"originalPreviewSize");
                        this$0.drawLargestRect(matOfPoint2f, pointArray, originalPreviewSize);
                        break block5;
                    }
                    this$0.clearAndInvalidateCanvas();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.DETECT_LARGEST_QUADRILATERAL_FAILED.getError(), (Throwable)e);
                    this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.DETECT_LARGEST_QUADRILATERAL_FAILED, e));
                    this$0.clearAndInvalidateCanvas();
                }
            } else {
                this$0.clearAndInvalidateCanvas();
            }
        }
        image.close();
    }

    public static final /* synthetic */ long access$getMillisLeft$p(ScanSurfaceView $this) {
        return $this.millisLeft;
    }

    public static final /* synthetic */ void access$setMillisLeft$p(ScanSurfaceView $this, long l) {
        $this.millisLeft = l;
    }

    public static final /* synthetic */ void access$setAutoCaptureScheduled$p(ScanSurfaceView $this, boolean bl) {
        $this.isAutoCaptureScheduled = bl;
    }

    public static final /* synthetic */ void access$autoCapture(ScanSurfaceView $this) {
        $this.autoCapture();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ void access$clearAndInvalidateCanvas(ScanSurfaceView $this) {
        $this.clearAndInvalidateCanvas();
    }

    public static final /* synthetic */ void access$setCapturing$p(ScanSurfaceView $this, boolean bl) {
        $this.isCapturing = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceView$Companion;", "", "()V", "DEFAULT_TIME_POST_PICTURE", "", "IMAGE_ANALYSIS_SCALE_WIDTH", "", "TAG", "", "TIME_POST_PICTURE", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

