/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.camerascreen;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import com.fondesa.kpermissions.PermissionStatus;
import com.fondesa.kpermissions.PermissionStatusKt;
import com.fondesa.kpermissions.extension.PermissionsBuilderKt;
import com.fondesa.kpermissions.request.PermissionRequest;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.common.extensions.ViewExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.FileUriUtils;
import com.zynksoftware.documentscanner.model.DocumentScannerErrorModel;
import com.zynksoftware.documentscanner.ui.base.BaseFragment;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceListener;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceView;
import com.zynksoftware.documentscanner.ui.scan.InternalScanActivity;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0002J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\u001a\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\tH\u0016J\b\u0010$\u001a\u00020\tH\u0002J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020\tH\u0002J\b\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\tH\u0002J\b\u0010+\u001a\u00020\tH\u0002J\b\u0010,\u001a\u00020\tH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment;", "Lcom/zynksoftware/documentscanner/ui/base/BaseFragment;", "Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "()V", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "checkForCameraPermissions", "", "checkForStoragePermissions", "finishActivity", "getScanActivity", "Lcom/zynksoftware/documentscanner/ui/scan/InternalScanActivity;", "getStoragePermission", "", "hideFlash", "initListeners", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onError", "error", "Lcom/zynksoftware/documentscanner/model/DocumentScannerErrorModel;", "onResume", "onViewCreated", "view", "scanSurfaceHideProgress", "scanSurfacePictureTaken", "scanSurfaceShowProgress", "selectImageFromGallery", "showFlash", "showFlashModeOff", "showFlashModeOn", "startCamera", "startCroppingProcess", "switchFlashState", "takePhoto", "toggleAutoManualButton", "Companion", "DocumentScanner_release"})
public final class CameraScreenFragment
extends BaseFragment
implements ScanSurfaceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ActivityResultLauncher<Intent> resultLauncher;
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(CameraScreenFragment.class).getSimpleName();

    public CameraScreenFragment() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> CameraScreenFragment.resultLauncher$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026        }\n        }\n    }");
        this.resultLauncher = activityResultLauncher;
        this._$_findViewCache = new LinkedHashMap();
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_camera_screen, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setLifecycleOwner((LifecycleOwner)this);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setListener(this);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setOriginalImageFile(this.getScanActivity().getOriginalImageFile$DocumentScanner_release());
        this.checkForCameraPermissions();
        this.initListeners();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getScanActivity().getShouldCallOnClose$DocumentScanner_release()) {
            this.getScanActivity().onClose();
        }
    }

    public void onResume() {
        super.onResume();
        this.getScanActivity().reInitOriginalImageFile$DocumentScanner_release();
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setOriginalImageFile(this.getScanActivity().getOriginalImageFile$DocumentScanner_release());
    }

    private final void initListeners() {
        this._$_findCachedViewById(R.id.cameraCaptureButton).setOnClickListener(arg_0 -> CameraScreenFragment.initListeners$lambda-1(this, arg_0));
        ((TextView)this._$_findCachedViewById(R.id.cancelButton)).setOnClickListener(arg_0 -> CameraScreenFragment.initListeners$lambda-2(this, arg_0));
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setOnClickListener(arg_0 -> CameraScreenFragment.initListeners$lambda-3(this, arg_0));
        ((ImageView)this._$_findCachedViewById(R.id.galleryButton)).setOnClickListener(arg_0 -> CameraScreenFragment.initListeners$lambda-4(this, arg_0));
        ((TextView)this._$_findCachedViewById(R.id.autoButton)).setOnClickListener(arg_0 -> CameraScreenFragment.initListeners$lambda-5(this, arg_0));
    }

    private final void toggleAutoManualButton() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setAutoCaptureOn(!((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).isAutoCaptureOn());
        if (((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).isAutoCaptureOn()) {
            ((TextView)this._$_findCachedViewById(R.id.autoButton)).setText((CharSequence)this.getString(R.string.zdc_auto));
        } else {
            ((TextView)this._$_findCachedViewById(R.id.autoButton)).setText((CharSequence)this.getString(R.string.zdc_manual));
        }
    }

    private final void checkForCameraPermissions() {
        PermissionRequest $this$send$iv = PermissionsBuilderKt.permissionsBuilder((Fragment)this, (String)"android.permission.CAMERA", (String[])new String[0]).build();
        boolean $i$f$send = false;
        $this$send$iv.addListener(new PermissionRequest.Listener($this$send$iv, this){
            final /* synthetic */ PermissionRequest $this_send;
            final /* synthetic */ CameraScreenFragment this$0;
            {
                this.$this_send = $receiver;
                this.this$0 = cameraScreenFragment;
            }

            public void onPermissionsResult(@NotNull List<? extends PermissionStatus> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                List<? extends PermissionStatus> result2 = result;
                boolean bl = false;
                if (PermissionStatusKt.allGranted(result2)) {
                    CameraScreenFragment.access$startCamera(this.this$0);
                } else if (PermissionStatusKt.allShouldShowRationale(result2)) {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_PERMISSION_REFUSED_WITHOUT_NEVER_ASK_AGAIN, null, 2, null));
                } else {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_PERMISSION_REFUSED_GO_TO_SETTINGS, null, 2, null));
                }
                this.$this_send.removeListener((PermissionRequest.Listener)this);
            }
        });
        $this$send$iv.send();
    }

    private final void checkForStoragePermissions() {
        PermissionRequest $this$send$iv = PermissionsBuilderKt.permissionsBuilder((Fragment)this, (String)this.getStoragePermission(), (String[])new String[0]).build();
        boolean $i$f$send = false;
        $this$send$iv.addListener(new PermissionRequest.Listener($this$send$iv, this){
            final /* synthetic */ PermissionRequest $this_send;
            final /* synthetic */ CameraScreenFragment this$0;
            {
                this.$this_send = $receiver;
                this.this$0 = cameraScreenFragment;
            }

            public void onPermissionsResult(@NotNull List<? extends PermissionStatus> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                List<? extends PermissionStatus> result2 = result;
                boolean bl = false;
                if (PermissionStatusKt.allGranted(result2)) {
                    CameraScreenFragment.access$selectImageFromGallery(this.this$0);
                } else if (PermissionStatusKt.allShouldShowRationale(result2)) {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.STORAGE_PERMISSION_REFUSED_WITHOUT_NEVER_ASK_AGAIN, null, 2, null));
                } else {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.STORAGE_PERMISSION_REFUSED_GO_TO_SETTINGS, null, 2, null));
                }
                this.$this_send.removeListener((PermissionRequest.Listener)this);
            }
        });
        $this$send$iv.send();
    }

    private final String getStoragePermission() {
        return Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.READ_EXTERNAL_STORAGE";
    }

    private final void startCamera() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).start();
    }

    private final void takePhoto() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).takePicture();
    }

    private final InternalScanActivity getScanActivity() {
        return (InternalScanActivity)this.requireActivity();
    }

    private final void finishActivity() {
        this.getScanActivity().finish();
    }

    private final void switchFlashState() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).switchFlashState();
    }

    @Override
    public void showFlash() {
        ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.flashButton);
        if (imageView != null) {
            ViewExtensionsKt.show((View)imageView);
        }
    }

    @Override
    public void hideFlash() {
        ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.flashButton);
        if (imageView != null) {
            ViewExtensionsKt.hide((View)imageView);
        }
    }

    private final void selectImageFromGallery() {
        Intent photoPickerIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
        photoPickerIntent.addCategory("android.intent.category.OPENABLE");
        photoPickerIntent.setType("image/*");
        this.resultLauncher.launch((Object)photoPickerIntent);
    }

    @Override
    public void scanSurfacePictureTaken() {
        this.startCroppingProcess();
    }

    private final void startCroppingProcess() {
        if (this.isAdded()) {
            this.getScanActivity().showImageCropFragment$DocumentScanner_release();
        }
    }

    @Override
    public void scanSurfaceShowProgress() {
        this.showProgressBar();
    }

    @Override
    public void scanSurfaceHideProgress() {
        this.hideProgressBar();
    }

    @Override
    public void onError(@NotNull DocumentScannerErrorModel error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.isAdded()) {
            this.getScanActivity().onError(error);
        }
    }

    @Override
    public void showFlashModeOn() {
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setImageResource(R.drawable.zdc_flash_on);
    }

    @Override
    public void showFlashModeOff() {
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setImageResource(R.drawable.zdc_flash_off);
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Override
    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.getView();
            if (view2 == null) {
                view = null;
            } else {
                View view3 = view2.findViewById(id2);
                if (view3 == null) {
                    view = null;
                } else {
                    map.put(id2, view3);
                    view = view3;
                }
            }
        }
        return view;
    }

    private static final void resultLauncher$lambda-0(CameraScreenFragment this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (result.getResultCode() == -1) {
            try {
                Uri imageUri;
                Object object;
                ActivityResult activityResult = result;
                if (activityResult == null) {
                    object = null;
                } else {
                    Intent intent = activityResult.getData();
                    object = imageUri = intent == null ? null : intent.getData();
                }
                if (imageUri != null) {
                    String realPath = FileUriUtils.INSTANCE.getRealPath((Context)this$0.getScanActivity(), imageUri);
                    if (realPath != null) {
                        this$0.getScanActivity().reInitOriginalImageFile$DocumentScanner_release();
                        this$0.getScanActivity().setOriginalImageFile$DocumentScanner_release(new File(realPath));
                        this$0.startCroppingProcess();
                    } else {
                        Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR.getError());
                        this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, null));
                    }
                } else {
                    Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR.getError());
                    this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, null));
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)"FileNotFoundException", (Throwable)e);
                this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, e));
            }
        }
    }

    private static final void initListeners$lambda-1(CameraScreenFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.takePhoto();
    }

    private static final void initListeners$lambda-2(CameraScreenFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.finishActivity();
    }

    private static final void initListeners$lambda-3(CameraScreenFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.switchFlashState();
    }

    private static final void initListeners$lambda-4(CameraScreenFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.checkForStoragePermissions();
    }

    private static final void initListeners$lambda-5(CameraScreenFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.toggleAutoManualButton();
    }

    public static final /* synthetic */ void access$startCamera(CameraScreenFragment $this) {
        $this.startCamera();
    }

    public static final /* synthetic */ void access$selectImageFromGallery(CameraScreenFragment $this) {
        $this.selectImageFromGallery();
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment$Companion;", "", "()V", "TAG", "", "newInstance", "Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment;", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CameraScreenFragment newInstance() {
            return new CameraScreenFragment();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

