/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.util.TypedValue;
import androidx.annotation.Keep;
import com.bumptech.glide.integration.webp.WebpHeaderParser;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Keep
public class WebpBitmapFactory {
    private static final int IN_TEMP_BUFFER_SIZE = 8192;
    private static final int MAX_WEBP_HEADER_SIZE = 21;

    private static void setDensityFromOptions(Bitmap outputBitmap, BitmapFactory.Options opts) {
        if (outputBitmap == null || opts == null) {
            return;
        }
        int density = opts.inDensity;
        if (density != 0) {
            outputBitmap.setDensity(density);
            int targetDensity = opts.inTargetDensity;
            if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
                return;
            }
            if (opts.inScaled) {
                outputBitmap.setDensity(targetDensity);
            }
        } else if (opts.inBitmap != null) {
            outputBitmap.setDensity(160);
        }
    }

    private static void setWebpBitmapOptions(Bitmap bitmap, BitmapFactory.Options opts) {
        WebpBitmapFactory.setDensityFromOptions(bitmap, opts);
        if (opts != null) {
            opts.outMimeType = "image/webp";
        }
    }

    @Keep
    private static boolean setOutDimensions(BitmapFactory.Options options, int imageWidth, int imageHeight) {
        if (options != null) {
            options.outWidth = imageWidth;
            options.outHeight = imageHeight;
            return options.inJustDecodeBounds;
        }
        return false;
    }

    @Keep
    private static Bitmap createBitmap(int width, int height, BitmapFactory.Options options) {
        if (options != null && options.inBitmap != null && options.inBitmap.isMutable()) {
            return options.inBitmap;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setHasAlpha(true);
        bitmap.eraseColor(0);
        return bitmap;
    }

    private static void setDefaultPadding(Rect padding) {
        if (padding != null) {
            padding.top = -1;
            padding.left = -1;
            padding.bottom = -1;
            padding.right = -1;
        }
    }

    public static boolean webpSupportRequired(byte[] headers, int offset, int length) {
        WebpHeaderParser.WebpImageType imageType;
        try {
            imageType = WebpHeaderParser.getType(headers, offset, length);
        }
        catch (IOException e) {
            imageType = WebpHeaderParser.WebpImageType.NONE_WEBP;
        }
        return Build.VERSION.SDK_INT <= 17 && WebpHeaderParser.isNonSimpleWebpType(imageType);
    }

    private static byte[] getImageHeader(InputStream is) {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 21);
        }
        is.mark(21);
        byte[] header = new byte[21];
        try {
            is.read(header, 0, 21);
            is.reset();
        }
        catch (IOException exp) {
            return null;
        }
        return header;
    }

    private static InputStream wrapToMarkSupportedStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 8192);
        }
        return inputStream;
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return WebpBitmapFactory.decodeByteArray(data, offset, length, null);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        Bitmap bm;
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (WebpBitmapFactory.webpSupportRequired(data, offset, length)) {
            bm = WebpBitmapFactory.nativeDecodeByteArray(data, offset, length, opts, WebpBitmapFactory.getScaleFromOptions(opts), WebpBitmapFactory.getInTempStorageFromOptions(opts));
            WebpBitmapFactory.setWebpBitmapOptions(bm, opts);
        } else {
            bm = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)opts);
        }
        return bm;
    }

    public static Bitmap decodeFile(String pathName) {
        return WebpBitmapFactory.decodeFile(pathName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String pathName, BitmapFactory.Options opts) {
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = WebpBitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
            Log.e((String)"WebpBitmapFactory", (String)("Unable to decode stream: " + e));
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id) {
        return WebpBitmapFactory.decodeResource(res, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeResource(Resources res, int id, BitmapFactory.Options opts) {
        Bitmap bm = null;
        InputStream is = null;
        try {
            TypedValue value = new TypedValue();
            is = res.openRawResource(id, value);
            bm = WebpBitmapFactory.decodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return WebpBitmapFactory.decodeStream(is, pad, opts);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        return WebpBitmapFactory.decodeFileDescriptor(fd, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        Bitmap bm;
        InputStream is = WebpBitmapFactory.wrapToMarkSupportedStream(new FileInputStream(fd));
        try {
            byte[] header = WebpBitmapFactory.getImageHeader(is);
            if (WebpBitmapFactory.webpSupportRequired(header, 0, 21)) {
                bm = WebpBitmapFactory.nativeDecodeStream(is, opts, WebpBitmapFactory.getScaleFromOptions(opts), WebpBitmapFactory.getInTempStorageFromOptions(opts));
                WebpBitmapFactory.setWebpBitmapOptions(bm, opts);
                WebpBitmapFactory.setDefaultPadding(outPadding);
            } else {
                bm = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)opts);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
        return bm;
    }

    public static Bitmap decodeStream(InputStream is) {
        return WebpBitmapFactory.decodeStream(is, null, null);
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        Bitmap bm;
        if (is == null) {
            return null;
        }
        byte[] header = WebpBitmapFactory.getImageHeader(is = WebpBitmapFactory.wrapToMarkSupportedStream(is));
        if (WebpBitmapFactory.webpSupportRequired(header, 0, 21)) {
            bm = WebpBitmapFactory.nativeDecodeStream(is, opts, WebpBitmapFactory.getScaleFromOptions(opts), WebpBitmapFactory.getInTempStorageFromOptions(opts));
            WebpBitmapFactory.setWebpBitmapOptions(bm, opts);
            WebpBitmapFactory.setDefaultPadding(outPadding);
        } else {
            bm = BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
        }
        return bm;
    }

    private static byte[] getInTempStorageFromOptions(BitmapFactory.Options options) {
        if (options != null && options.inTempStorage != null) {
            return options.inTempStorage;
        }
        return new byte[8192];
    }

    private static float getScaleFromOptions(BitmapFactory.Options options) {
        float scale = 1.0f;
        if (options != null) {
            int sampleSize = options.inSampleSize;
            if (sampleSize > 1) {
                scale = 1.0f / (float)sampleSize;
            }
            if (options.inScaled) {
                int density = options.inDensity;
                int targetDensity = options.inTargetDensity;
                int screenDensity = options.inScreenDensity;
                if (density != 0 && targetDensity != 0 && density != screenDensity) {
                    scale = (float)targetDensity / (float)density;
                }
            }
        }
        return scale;
    }

    private static native Bitmap nativeDecodeStream(InputStream var0, BitmapFactory.Options var1, float var2, byte[] var3);

    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, BitmapFactory.Options var3, float var4, byte[] var5);

    static {
        System.loadLibrary("glide-webp");
    }
}

