/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.http;

import cn.hutool.core.util.StrUtil;
import java.util.Map;
import org.muyie.framework.http.ResultCode;

public class ResultCodeBuilder
implements ResultCode {
    private final String code;
    private final String msg;

    public static ResultCodeBuilder of(ResultCode resultCode) {
        return ResultCodeBuilder.of(resultCode.getCode(), resultCode.getMsg());
    }

    public static ResultCodeBuilder of(ResultCode resultCode, Map<?, ?> map) {
        return ResultCodeBuilder.of(resultCode.getCode(), StrUtil.format((CharSequence)resultCode.getMsg(), map));
    }

    public static ResultCodeBuilder of(ResultCode resultCode, Object ... params) {
        return ResultCodeBuilder.of(resultCode.getCode(), StrUtil.format((CharSequence)resultCode.getMsg(), (Object[])params));
    }

    public static ResultCodeBuilder of(String code, String msg) {
        return new ResultCodeBuilder(code, msg);
    }

    public static ResultCodeBuilder of(String code, String msg, Map<?, ?> map) {
        return new ResultCodeBuilder(code, StrUtil.format((CharSequence)msg, map));
    }

    public static ResultCodeBuilder of(String code, String msg, Object ... params) {
        return new ResultCodeBuilder(code, StrUtil.format((CharSequence)msg, (Object[])params));
    }

    private ResultCodeBuilder(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }
}

