/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.http;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.muyie.framework.http.ResultCode;
import org.muyie.framework.http.ResultCodeBuilder;
import org.muyie.framework.http.ResultCodeDefined;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String msg;
    private Object bizContent;
    @JsonIgnore
    private HttpHeaders headers;
    private String sign;

    public static Result of(@NonNull ResultCode resultCode) {
        return Result.of(resultCode, null, null);
    }

    public static Result of(@NonNull ResultCode resultCode, @Nullable MultiValueMap<String, String> headers) {
        return Result.of(resultCode, null, headers);
    }

    public static Result of(@NonNull ResultCode resultCode, @Nullable Object bizContent) {
        return Result.of(resultCode, bizContent, null);
    }

    public static Result of(@NonNull ResultCode resultCode, @Nullable Object bizContent, @Nullable MultiValueMap<String, String> headers) {
        Result result = new Result(resultCode.getCode(), resultCode.getMsg(), bizContent);
        HttpHeaders tempHeaders = new HttpHeaders();
        if (headers != null) {
            tempHeaders.putAll(headers);
        }
        result.setHeaders(HttpHeaders.readOnlyHttpHeaders((HttpHeaders)tempHeaders));
        return result;
    }

    public static Result of(String code, String msg, Map<?, ?> map) {
        ResultCodeBuilder builder = ResultCodeBuilder.of(code, StrUtil.format((CharSequence)msg, map));
        return Result.of(builder);
    }

    public static Result of(String code, String msg, Object ... params) {
        ResultCodeBuilder builder = ResultCodeBuilder.of(code, StrUtil.format((CharSequence)msg, (Object[])params));
        return Result.of(builder);
    }

    public static Result ok() {
        return Result.ok(null, null);
    }

    public static Result ok(@Nullable MultiValueMap<String, String> headers) {
        return Result.ok(null, headers);
    }

    public static Result ok(@Nullable Object bizContent) {
        return Result.ok(bizContent, null);
    }

    public static Result ok(@Nullable Object bizContent, @Nullable MultiValueMap<String, String> headers) {
        return Result.of(ResultCodeDefined.SC_200, bizContent, headers);
    }

    public Result() {
    }

    private Result(String code, String msg, Object bizContent) {
        this.code = code;
        this.msg = msg;
        this.bizContent = bizContent;
    }

    public Object getBizContent() {
        return Objects.nonNull(this.bizContent) ? this.bizContent : Maps.newConcurrentMap();
    }

    public String getCode() {
        return Strings.nullToEmpty((String)this.code);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getMsg() {
        return Strings.nullToEmpty((String)this.msg);
    }

    public String getSign() {
        return Strings.nullToEmpty((String)this.sign);
    }

    public boolean isSuccess() {
        return ResultCodeDefined.SC_200.getCode().equals(this.getCode());
    }

    public void setBizContent(Object bizContent) {
        this.bizContent = bizContent;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}

