/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config.aspectj;

import org.muyie.framework.config.MuyieProperties;
import org.muyie.framework.http.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.zalando.problem.Problem;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={MuyieProperties.class})
@RestControllerAdvice
public class MuyieResponseAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof Problem) {
            Problem problem = (Problem)body;
            return Result.of(String.valueOf(problem.getStatus().getStatusCode()), problem.getTitle(), new Object[0]);
        }
        if (body instanceof Result) {
            Result result = (Result)body;
            response.getHeaders().addAll((MultiValueMap)result.getHeaders());
            return result;
        }
        return body;
    }
}

