/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config.aspectj;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Throwables;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.muyie.framework.aop.AfterThrowingAdvice;
import org.muyie.framework.aop.AroundAdvice;
import org.muyie.framework.config.aspectj.LogAudited;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

@Aspect
@Profile(value={"dev", "debug"})
public class LogAuditedAspect
implements AroundAdvice,
AfterThrowingAdvice {
    private static final Logger log = LoggerFactory.getLogger(LogAuditedAspect.class);

    @Override
    @Pointcut(value="@annotation(org.muyie.framework.config.aspectj.LogAudited)")
    public void setPointcut() {
    }

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public void springBeanPointcut() {
    }

    @Override
    @AfterThrowing(pointcut="setPointcut() && springBeanPointcut()", throwing="e")
    public void afterThrowing(JoinPoint joinPoint, Throwable e) {
        String value = this.getMethod(joinPoint).getAnnotation(LogAudited.class).value();
        if (StringUtils.isEmpty((Object)value)) {
            value = StrUtil.format((CharSequence)"{}.{}()", (Object[])new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
        }
        log.error("LogAudited Exception: '{}' with cause = {}", (Object)value, (Object)Throwables.getStackTraceAsString((Throwable)e));
    }

    @Override
    @Around(value="setPointcut() && springBeanPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String value = this.getMethod(joinPoint).getAnnotation(LogAudited.class).value();
        if (StringUtils.isEmpty((Object)value)) {
            value = StrUtil.format((CharSequence)"{}.{}()", (Object[])new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
        }
        try {
            log.debug("LogAudited Enter: '{}' with arguments = {}", (Object)value, (Object)JSON.toJSONString((Object)joinPoint.getArgs()));
            Object result = joinPoint.proceed();
            log.debug("LogAudited Exit: '{}' with result = {}", (Object)value, (Object)JSON.toJSONString((Object)result));
            return result;
        }
        catch (IllegalArgumentException e) {
            log.error("LogAudited Illegal argument: '{}' in {}", (Object)JSON.toJSONString((Object)joinPoint.getArgs()), (Object)value);
            throw e;
        }
    }
}

