/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.async;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.AsyncTaskExecutor;

public class MuyieAsyncTaskExecutor
implements AsyncTaskExecutor,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MuyieAsyncTaskExecutor.class);
    private static final String EXCEPTION_MESSAGE = "Caught async exception";
    private final AsyncTaskExecutor taskExecutor;

    public MuyieAsyncTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void execute(Runnable task) {
        this.taskExecutor.execute(this.createWrappedRunnable(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.taskExecutor.execute(this.createWrappedRunnable(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.taskExecutor.submit(this.createWrappedRunnable(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.taskExecutor.submit(this.createCallable(task));
    }

    public void destroy() throws Exception {
        if (this.taskExecutor instanceof DisposableBean) {
            DisposableBean bean = (DisposableBean)this.taskExecutor;
            bean.destroy();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskExecutor instanceof InitializingBean) {
            InitializingBean bean = (InitializingBean)this.taskExecutor;
            bean.afterPropertiesSet();
        }
    }

    private <T> Callable<T> createCallable(Callable<T> task) {
        return () -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                this.handle(e);
                throw e;
            }
        };
    }

    private Runnable createWrappedRunnable(Runnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.handle(e);
            }
        };
    }

    protected void handle(Throwable e) {
        log.error(EXCEPTION_MESSAGE, e);
    }
}

