/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.async;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.muyie.framework.config.MuyieProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class MuyieAsyncConfigurer
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(MuyieAsyncConfigurer.class);
    private static final String EXCEPTION_MESSAGE = "Caught async exception";
    private final MuyieProperties.Async properties;

    public MuyieAsyncConfigurer(MuyieProperties muyieProperties) {
        this.properties = muyieProperties.getAsync();
    }

    public AsyncTaskExecutor create() {
        log.debug("Creating Async Task Executor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.properties.getCorePoolSize());
        executor.setMaxPoolSize(this.properties.getMaxPoolSize());
        executor.setQueueCapacity(this.properties.getQueueCapacity());
        executor.setAllowCoreThreadTimeOut(this.properties.isAllowCoreThreadTimeOut());
        executor.setWaitForTasksToCompleteOnShutdown(this.properties.isWaitForJobsToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(this.properties.getAwaitTerminationSeconds());
        executor.setKeepAliveSeconds(this.properties.getKeepAliveSeconds());
        executor.setThreadNamePrefix(this.properties.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public Executor getAsyncExecutor() {
        return this.create();
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (e, method, params) -> this.handle(e);
    }

    protected void handle(Throwable e) {
        log.error(EXCEPTION_MESSAGE, e);
    }
}

