/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.drawer;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.zhpan.indicator.drawer.BaseDrawer;
import com.zhpan.indicator.option.IndicatorOptions;
import com.zhpan.indicator.utils.IndicatorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/zhpan/indicator/drawer/CircleDrawer;", "Lcom/zhpan/indicator/drawer/BaseDrawer;", "indicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "(Lcom/zhpan/indicator/option/IndicatorOptions;)V", "rectF", "Landroid/graphics/RectF;", "drawCircle", "", "canvas", "Landroid/graphics/Canvas;", "coordinateX", "", "coordinateY", "radius", "drawCircleSlider", "drawNormal", "drawSlider", "drawWormSlider", "sliderHeight", "measureHeight", "", "onDraw", "indicator_release"})
public final class CircleDrawer
extends BaseDrawer {
    private final RectF rectF;

    @Override
    protected int measureHeight() {
        return (int)this.getMaxWidth$indicator_release();
    }

    @Override
    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.getMIndicatorOptions$indicator_release().getPageSize() > 1) {
            this.drawNormal(canvas);
            this.drawSlider(canvas);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawNormal(Canvas canvas) {
        float normalIndicatorWidth = this.getMIndicatorOptions$indicator_release().getNormalSliderWidth();
        this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getNormalSliderColor());
        int n = 0;
        int n2 = this.getMIndicatorOptions$indicator_release().getPageSize();
        while (n < n2) {
            void i;
            float coordinateX = IndicatorUtils.INSTANCE.getCoordinateX(this.getMIndicatorOptions$indicator_release(), this.getMaxWidth$indicator_release(), (int)i);
            float coordinateY = IndicatorUtils.INSTANCE.getCoordinateY(this.getMaxWidth$indicator_release());
            this.drawCircle(canvas, coordinateX, coordinateY, normalIndicatorWidth / (float)2);
            ++i;
        }
    }

    private final void drawSlider(Canvas canvas) {
        this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getCheckedSliderColor());
        switch (this.getMIndicatorOptions$indicator_release().getSlideMode()) {
            case 0: 
            case 2: {
                this.drawCircleSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas, this.getMIndicatorOptions$indicator_release().getNormalSliderWidth());
            }
        }
    }

    private final void drawCircleSlider(Canvas canvas) {
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float startCoordinateX = IndicatorUtils.INSTANCE.getCoordinateX(this.getMIndicatorOptions$indicator_release(), this.getMaxWidth$indicator_release(), currentPosition);
        float endCoordinateX = IndicatorUtils.INSTANCE.getCoordinateX(this.getMIndicatorOptions$indicator_release(), this.getMaxWidth$indicator_release(), (currentPosition + 1) % this.getMIndicatorOptions$indicator_release().getPageSize());
        float coordinateX = startCoordinateX + (endCoordinateX - startCoordinateX) * this.getMIndicatorOptions$indicator_release().getSlideProgress();
        float coordinateY = IndicatorUtils.INSTANCE.getCoordinateY(this.getMaxWidth$indicator_release());
        float radius = this.getMIndicatorOptions$indicator_release().getCheckedSliderWidth() / (float)2;
        this.drawCircle(canvas, coordinateX, coordinateY, radius);
    }

    private final void drawWormSlider(Canvas canvas, float sliderHeight) {
        float slideProgress = this.getMIndicatorOptions$indicator_release().getSlideProgress();
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float distance = this.getMIndicatorOptions$indicator_release().getSliderGap() + this.getMIndicatorOptions$indicator_release().getNormalSliderWidth();
        float startCoordinateX = IndicatorUtils.INSTANCE.getCoordinateX(this.getMIndicatorOptions$indicator_release(), this.getMaxWidth$indicator_release(), currentPosition);
        float left = startCoordinateX + Math.max(distance * (slideProgress - 0.5f) * 2.0f, 0.0f) - this.getMIndicatorOptions$indicator_release().getNormalSliderWidth() / (float)2;
        float right = startCoordinateX + Math.min(distance * slideProgress * 2.0f, distance) + this.getMIndicatorOptions$indicator_release().getNormalSliderWidth() / (float)2;
        this.rectF.set(left, 0.0f, right, sliderHeight);
        canvas.drawRoundRect(this.rectF, sliderHeight, sliderHeight, this.getMPaint$indicator_release());
    }

    private final void drawCircle(Canvas canvas, float coordinateX, float coordinateY, float radius) {
        canvas.drawCircle(coordinateX, coordinateY, radius, this.getMPaint$indicator_release());
    }

    public CircleDrawer(@NotNull IndicatorOptions indicatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"indicatorOptions");
        super(indicatorOptions);
        this.rectF = new RectF();
    }
}

