/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.zhpan.indicator.base.BaseIndicatorView;
import com.zhpan.indicator.base.IIndicator;
import com.zhpan.indicator.option.IndicatorOptions;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u001b*\u0001\u001e\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00101\u001a\u0004\u0018\u00010\u0018J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\bH\u0016J \u00106\u001a\u0002032\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\bH\u0016J\u0010\u0010:\u001a\u0002032\u0006\u00107\u001a\u00020\bH\u0016J\u0018\u0010;\u001a\u0002032\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\u000eH\u0002J\u0010\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020\u0018H\u0016J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\bJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\bJ\u001a\u0010A\u001a\u00020\u00002\b\b\u0001\u0010$\u001a\u00020\b2\b\b\u0001\u0010B\u001a\u00020\bJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u000eJ\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u000eJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u000eJ\u0016\u0010G\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u000eJ\b\u0010J\u001a\u000203H\u0002J\u000e\u0010K\u001a\u0002032\u0006\u0010L\u001a\u00020!J\u000e\u0010K\u001a\u0002032\u0006\u0010M\u001a\u00020#R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u0011\u0010&\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0010R$\u0010(\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\f\"\u0004\b*\u0010\u0014R\u0011\u0010+\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\fR$\u0010-\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0010\"\u0004\b/\u00100\u00a8\u0006N"}, d2={"Lcom/zhpan/indicator/base/BaseIndicatorView;", "Landroid/view/View;", "Lcom/zhpan/indicator/base/IIndicator;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "checkedColor", "getCheckedColor", "()I", "checkedSliderWidth", "", "getCheckedSliderWidth", "()F", "currentPosition", "getCurrentPosition", "setCurrentPosition", "(I)V", "indicatorGap", "getIndicatorGap", "mIndicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "getMIndicatorOptions", "()Lcom/zhpan/indicator/option/IndicatorOptions;", "setMIndicatorOptions", "(Lcom/zhpan/indicator/option/IndicatorOptions;)V", "mOnPageChangeCallback", "com/zhpan/indicator/base/BaseIndicatorView$mOnPageChangeCallback$1", "Lcom/zhpan/indicator/base/BaseIndicatorView$mOnPageChangeCallback$1;", "mViewPager", "Landroidx/viewpager/widget/ViewPager;", "mViewPager2", "Landroidx/viewpager2/widget/ViewPager2;", "normalColor", "getNormalColor", "normalSliderWidth", "getNormalSliderWidth", "pageSize", "getPageSize", "setPageSize", "slideMode", "getSlideMode", "slideProgress", "getSlideProgress", "setSlideProgress", "(F)V", "getIndicatorOptions", "notifyDataChanged", "", "onPageScrollStateChanged", "state", "onPageScrolled", "position", "positionOffset", "positionOffsetPixels", "onPageSelected", "scrollSlider", "setIndicatorOptions", "options", "setIndicatorStyle", "indicatorStyle", "setSlideMode", "setSliderColor", "selectedColor", "setSliderGap", "sliderGap", "setSliderHeight", "sliderHeight", "setSliderWidth", "sliderWidth", "selectedSliderWidth", "setupViewPager", "setupWithViewPager", "viewPager", "viewPager2", "indicator_release"})
public class BaseIndicatorView
extends View
implements IIndicator {
    @NotNull
    private IndicatorOptions mIndicatorOptions;
    private ViewPager mViewPager;
    private ViewPager2 mViewPager2;
    private final mOnPageChangeCallback.1 mOnPageChangeCallback;
    private HashMap _$_findViewCache;

    @NotNull
    public final IndicatorOptions getMIndicatorOptions() {
        return this.mIndicatorOptions;
    }

    public final void setMIndicatorOptions(@NotNull IndicatorOptions indicatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"<set-?>");
        this.mIndicatorOptions = indicatorOptions;
    }

    public final int getPageSize() {
        return this.mIndicatorOptions.getPageSize();
    }

    private final void setPageSize(int pageSize) {
        this.mIndicatorOptions.setPageSize(pageSize);
    }

    public final int getNormalColor() {
        return this.mIndicatorOptions.getNormalSliderColor();
    }

    public final int getCheckedColor() {
        return this.mIndicatorOptions.getCheckedSliderColor();
    }

    public final float getIndicatorGap() {
        return this.mIndicatorOptions.getSliderGap();
    }

    public final float getSlideProgress() {
        return this.mIndicatorOptions.getSlideProgress();
    }

    private final void setSlideProgress(float slideProgress) {
        this.mIndicatorOptions.setSlideProgress(slideProgress);
    }

    public final int getCurrentPosition() {
        return this.mIndicatorOptions.getCurrentPosition();
    }

    private final void setCurrentPosition(int currentPosition) {
        this.mIndicatorOptions.setCurrentPosition(currentPosition);
    }

    public final int getSlideMode() {
        return this.mIndicatorOptions.getSlideMode();
    }

    public final float getNormalSliderWidth() {
        return this.mIndicatorOptions.getNormalSliderWidth();
    }

    public final float getCheckedSliderWidth() {
        return this.mIndicatorOptions.getCheckedSliderWidth();
    }

    public void onPageSelected(int position) {
        if (this.getSlideMode() == 0) {
            this.setCurrentPosition(position);
            this.setSlideProgress(0.0f);
            this.invalidate();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.getSlideMode() != 0 && this.getPageSize() > 1) {
            this.scrollSlider(position, positionOffset);
            this.invalidate();
        }
    }

    private final void scrollSlider(int position, float positionOffset) {
        if (position % this.getPageSize() == this.getPageSize() - 1) {
            if ((double)positionOffset < 0.5) {
                this.setCurrentPosition(position);
                this.setSlideProgress(0.0f);
            } else {
                this.setCurrentPosition(0);
                this.setSlideProgress(0.0f);
            }
        } else {
            this.setCurrentPosition(position);
            this.setSlideProgress(positionOffset);
        }
    }

    @Override
    public void notifyDataChanged() {
        this.setupViewPager();
        this.requestLayout();
        this.invalidate();
    }

    private final void setupViewPager() {
        if (this.mViewPager != null) {
            ViewPager viewPager = this.mViewPager;
            if (viewPager == null) {
                Intrinsics.throwNpe();
            }
            viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            ViewPager viewPager2 = this.mViewPager;
            if (viewPager2 == null) {
                Intrinsics.throwNpe();
            }
            viewPager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            ViewPager viewPager3 = this.mViewPager;
            if (viewPager3 == null) {
                Intrinsics.throwNpe();
            }
            if (viewPager3.getAdapter() != null) {
                ViewPager viewPager4 = this.mViewPager;
                if (viewPager4 == null) {
                    Intrinsics.throwNpe();
                }
                PagerAdapter pagerAdapter = viewPager4.getAdapter();
                if (pagerAdapter == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pagerAdapter, (String)"mViewPager!!.adapter!!");
                this.setPageSize(pagerAdapter.getCount());
            }
        } else if (this.mViewPager2 != null) {
            ViewPager2 viewPager2 = this.mViewPager2;
            if (viewPager2 == null) {
                Intrinsics.throwNpe();
            }
            viewPager2.unregisterOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.mOnPageChangeCallback);
            ViewPager2 viewPager22 = this.mViewPager2;
            if (viewPager22 == null) {
                Intrinsics.throwNpe();
            }
            viewPager22.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.mOnPageChangeCallback);
            ViewPager2 viewPager23 = this.mViewPager2;
            if (viewPager23 == null) {
                Intrinsics.throwNpe();
            }
            if (viewPager23.getAdapter() != null) {
                ViewPager2 viewPager24 = this.mViewPager2;
                if (viewPager24 == null) {
                    Intrinsics.throwNpe();
                }
                RecyclerView.Adapter adapter = viewPager24.getAdapter();
                if (adapter == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)adapter, (String)"mViewPager2!!.adapter!!");
                this.setPageSize(adapter.getItemCount());
            }
        }
    }

    @NotNull
    public final BaseIndicatorView setSliderColor(@ColorInt int normalColor, @ColorInt int selectedColor) {
        this.mIndicatorOptions.setSliderColor(normalColor, selectedColor);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setSliderWidth(float sliderWidth) {
        this.mIndicatorOptions.setSliderWidth(sliderWidth);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setSliderWidth(float normalSliderWidth, float selectedSliderWidth) {
        this.mIndicatorOptions.setSliderWidth(normalSliderWidth, selectedSliderWidth);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setSliderGap(float sliderGap) {
        this.mIndicatorOptions.setSliderGap(sliderGap);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setSlideMode(int slideMode) {
        this.mIndicatorOptions.setSlideMode(slideMode);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorOptions.setIndicatorStyle(indicatorStyle);
        return this;
    }

    @NotNull
    public final BaseIndicatorView setSliderHeight(float sliderHeight) {
        this.mIndicatorOptions.setSliderHeight(sliderHeight);
        return this;
    }

    public final void setupWithViewPager(@NotNull ViewPager viewPager) {
        Intrinsics.checkParameterIsNotNull((Object)viewPager, (String)"viewPager");
        this.mViewPager = viewPager;
        this.notifyDataChanged();
    }

    public final void setupWithViewPager(@NotNull ViewPager2 viewPager2) {
        Intrinsics.checkParameterIsNotNull((Object)viewPager2, (String)"viewPager2");
        this.mViewPager2 = viewPager2;
        this.notifyDataChanged();
    }

    @Nullable
    public final IndicatorOptions getIndicatorOptions() {
        return this.mIndicatorOptions;
    }

    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void setIndicatorOptions(@NotNull IndicatorOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.mIndicatorOptions = options;
    }

    @JvmOverloads
    public BaseIndicatorView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mOnPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                this.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }

            public void onPageSelected(int position) {
                this.onPageSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
                this.onPageScrollStateChanged(state);
            }
        };
        this.mIndicatorOptions = new IndicatorOptions();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

