/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicatorview.drawer;

import android.graphics.Paint;
import android.graphics.RectF;
import com.zhpan.indicatorview.drawer.IDrawer;
import com.zhpan.indicatorview.model.IndicatorOptions;

public abstract class BaseDrawer
implements IDrawer {
    private MeasureResult mMeasureResult;
    IndicatorOptions mIndicatorOptions;
    float maxWidth;
    float minWidth;
    Paint mPaint;
    RectF mRectF;

    BaseDrawer(IndicatorOptions indicatorOptions) {
        this.mIndicatorOptions = indicatorOptions;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mMeasureResult = new MeasureResult();
        this.mRectF = new RectF();
    }

    @Override
    public MeasureResult onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.maxWidth = Math.max(this.mIndicatorOptions.getNormalIndicatorWidth(), this.mIndicatorOptions.getCheckedIndicatorWidth());
        this.minWidth = Math.min(this.mIndicatorOptions.getNormalIndicatorWidth(), this.mIndicatorOptions.getCheckedIndicatorWidth());
        this.mMeasureResult.setMeasureResult(this.measureWidth(), this.measureHeight());
        return this.mMeasureResult;
    }

    protected int measureHeight() {
        return (int)this.mIndicatorOptions.getSliderHeight();
    }

    private int measureWidth() {
        int pageSize = this.mIndicatorOptions.getPageSize();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        return (int)((float)(pageSize - 1) * indicatorGap + this.maxWidth + (float)(pageSize - 1) * this.minWidth);
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected boolean isWidthEquals() {
        return this.mIndicatorOptions.getNormalIndicatorWidth() == this.mIndicatorOptions.getCheckedIndicatorWidth();
    }

    public class MeasureResult {
        int measureWidth;
        int measureHeight;

        void setMeasureResult(int measureWidth, int measureHeight) {
            this.measureWidth = measureWidth;
            this.measureHeight = measureHeight;
        }

        public int getMeasureWidth() {
            return this.measureWidth;
        }

        public int getMeasureHeight() {
            return this.measureHeight;
        }
    }
}

