/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.zhpan.bannerview.BaseBannerAdapter;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.manager.BannerManager;
import com.zhpan.bannerview.manager.BannerOptions;
import com.zhpan.bannerview.provider.ReflectLayoutManager;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.utils.BannerUtils;
import com.zhpan.indicator.IndicatorView;
import com.zhpan.indicator.base.IIndicator;
import com.zhpan.indicator.option.IndicatorOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BannerViewPager<T>
extends RelativeLayout
implements LifecycleObserver {
    private int currentPosition;
    private boolean isCustomIndicator;
    private boolean isLooping;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    private RelativeLayout mIndicatorLayout;
    private ViewPager2 mViewPager;
    private BannerManager mBannerManager;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private BaseBannerAdapter<T> mBannerPagerAdapter;
    private ViewPager2.OnPageChangeCallback onPageChangeCallback;
    private final Runnable mRunnable = this::handlePosition;
    private RectF mRadiusRectF;
    private Path mRadiusPath;
    private int startX;
    private int startY;
    private final ViewPager2.OnPageChangeCallback mOnPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            super.onPageScrolled(position, positionOffset, positionOffsetPixels);
            BannerViewPager.this.pageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            super.onPageSelected(position);
            BannerViewPager.this.pageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
            super.onPageScrollStateChanged(state);
            BannerViewPager.this.pageScrollStateChanged(state);
        }
    };
    private static final String KEY_SUPER_STATE = "SUPER_STATE";
    private static final String KEY_CURRENT_POSITION = "CURRENT_POSITION";
    private static final String KEY_IS_CUSTOM_INDICATOR = "IS_CUSTOM_INDICATOR";

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mBannerManager = new BannerManager();
        this.mBannerManager.initAttrs(context, attrs);
        this.initView();
    }

    private void initView() {
        BannerViewPager.inflate((Context)this.getContext(), (int)R.layout.bvp_layout, (ViewGroup)this);
        this.mViewPager = (ViewPager2)this.findViewById(R.id.vp_main);
        this.mIndicatorLayout = (RelativeLayout)this.findViewById(R.id.bvp_layout_indicator);
        this.mViewPager.setPageTransformer((ViewPager2.PageTransformer)this.mBannerManager.getCompositePageTransformer());
    }

    protected void onDetachedFromWindow() {
        if (this.mBannerManager != null && this.mBannerManager.getBannerOptions().isStopLoopWhenDetachedFromWindow()) {
            this.stopLoop();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mBannerManager != null && this.mBannerManager.getBannerOptions().isStopLoopWhenDetachedFromWindow()) {
            this.startLoop();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.isLooping = true;
                this.stopLoop();
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.isLooping = false;
                this.startLoop();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean doNotNeedIntercept;
        boolean bl = doNotNeedIntercept = !this.mViewPager.isUserInputEnabled() || this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getData().size() <= 1;
        if (doNotNeedIntercept) {
            return super.onInterceptTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                this.startX = (int)ev.getX();
                this.startY = (int)ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(!this.mBannerManager.getBannerOptions().isDisallowParentInterceptDownEvent());
                break;
            }
            case 2: {
                int endX = (int)ev.getX();
                int endY = (int)ev.getY();
                int disX = Math.abs(endX - this.startX);
                int disY = Math.abs(endY - this.startY);
                int orientation = this.mBannerManager.getBannerOptions().getOrientation();
                if (orientation == 1) {
                    this.onVerticalActionMove(endY, disX, disY);
                    break;
                }
                if (orientation != 0) break;
                this.onHorizontalActionMove(endX, disX, disY);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void onVerticalActionMove(int endY, int disX, int disY) {
        if (disY > disX) {
            boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
            if (!canLoop) {
                if (this.currentPosition == 0 && endY - this.startY > 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    this.getParent().requestDisallowInterceptTouchEvent(this.currentPosition != this.getData().size() - 1 || endY - this.startY >= 0);
                }
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else if (disX > disY) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
    }

    private void onHorizontalActionMove(int endX, int disX, int disY) {
        if (disX > disY) {
            boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
            if (!canLoop) {
                if (this.currentPosition == 0 && endX - this.startX > 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    this.getParent().requestDisallowInterceptTouchEvent(this.currentPosition != this.getData().size() - 1 || endX - this.startX >= 0);
                }
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else if (disY > disX) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
    }

    private void pageScrollStateChanged(int state) {
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrollStateChanged(state);
        }
        if (this.onPageChangeCallback != null) {
            this.onPageChangeCallback.onPageScrollStateChanged(state);
        }
    }

    private void pageSelected(int position) {
        boolean needResetCurrentItem;
        int size = this.mBannerPagerAdapter.getListSize();
        boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
        this.currentPosition = BannerUtils.getRealPosition(position, size);
        boolean bl = needResetCurrentItem = size > 0 && canLoop && (position == 0 || position == 999);
        if (needResetCurrentItem) {
            this.resetCurrentItem(this.currentPosition);
        }
        if (this.onPageChangeCallback != null) {
            this.onPageChangeCallback.onPageSelected(this.currentPosition);
        }
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageSelected(this.currentPosition);
        }
    }

    private void pageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        int listSize = this.mBannerPagerAdapter.getListSize();
        boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
        int realPosition = BannerUtils.getRealPosition(position, listSize);
        if (listSize > 0) {
            if (this.onPageChangeCallback != null) {
                this.onPageChangeCallback.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
            if (this.mIndicatorView != null) {
                this.mIndicatorView.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
        }
    }

    private void handlePosition() {
        if (this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1 && this.isAutoPlay()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
        }
    }

    private void initBannerData() {
        List<T> list = this.mBannerPagerAdapter.getData();
        if (list != null) {
            this.setIndicatorValues(list);
            this.setupViewPager(list);
            this.initRoundCorner();
        }
    }

    private void setIndicatorValues(List<? extends T> list) {
        BannerOptions bannerOptions = this.mBannerManager.getBannerOptions();
        this.mIndicatorLayout.setVisibility(bannerOptions.getIndicatorVisibility());
        bannerOptions.resetIndicatorOptions();
        if (!this.isCustomIndicator || null == this.mIndicatorView) {
            this.mIndicatorView = new IndicatorView(this.getContext());
        }
        this.initIndicator(bannerOptions.getIndicatorOptions(), list);
    }

    private void initIndicator(IndicatorOptions indicatorOptions, List<? extends T> list) {
        if (((View)this.mIndicatorView).getParent() == null) {
            this.mIndicatorLayout.removeAllViews();
            this.mIndicatorLayout.addView((View)this.mIndicatorView);
            this.initIndicatorSliderMargin();
            this.initIndicatorGravity();
        }
        this.mIndicatorView.setIndicatorOptions(indicatorOptions);
        indicatorOptions.setPageSize(list.size());
        this.mIndicatorView.notifyDataChanged();
    }

    private void initIndicatorGravity() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((View)this.mIndicatorView).getLayoutParams();
        switch (this.mBannerManager.getBannerOptions().getIndicatorGravity()) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 2: {
                layoutParams.addRule(9);
                break;
            }
            case 4: {
                layoutParams.addRule(11);
                break;
            }
        }
    }

    private void initIndicatorSliderMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)((View)this.mIndicatorView).getLayoutParams();
        BannerOptions.IndicatorMargin indicatorMargin = this.mBannerManager.getBannerOptions().getIndicatorMargin();
        if (indicatorMargin == null) {
            int dp10 = BannerUtils.dp2px(10.0f);
            layoutParams.setMargins(dp10, dp10, dp10, dp10);
        } else {
            layoutParams.setMargins(indicatorMargin.getLeft(), indicatorMargin.getTop(), indicatorMargin.getRight(), indicatorMargin.getBottom());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        float[] roundRectRadiusArray = this.mBannerManager.getBannerOptions().getRoundRectRadiusArray();
        if (this.mRadiusRectF != null && this.mRadiusPath != null && roundRectRadiusArray != null) {
            this.mRadiusRectF.right = this.getWidth();
            this.mRadiusRectF.bottom = this.getHeight();
            this.mRadiusPath.addRoundRect(this.mRadiusRectF, roundRectRadiusArray, Path.Direction.CW);
            canvas.clipPath(this.mRadiusPath);
        }
        super.dispatchDraw(canvas);
    }

    private void initRoundCorner() {
        int roundCorner = this.mBannerManager.getBannerOptions().getRoundRectRadius();
        if (roundCorner > 0 && Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter.applyRoundCorner((View)this, roundCorner);
        }
    }

    private void setupViewPager(List<T> list) {
        if (this.mBannerPagerAdapter == null) {
            throw new NullPointerException("You must set adapter for BannerViewPager");
        }
        BannerOptions bannerOptions = this.mBannerManager.getBannerOptions();
        if (bannerOptions.getScrollDuration() != 0) {
            ReflectLayoutManager.reflectLayoutManager(this.mViewPager, bannerOptions.getScrollDuration());
        }
        this.currentPosition = 0;
        this.mBannerPagerAdapter.setCanLoop(bannerOptions.isCanLoop());
        this.mBannerPagerAdapter.setPageClickListener(this.mOnPageClickListener);
        this.mViewPager.setAdapter(this.mBannerPagerAdapter);
        if (this.isCanLoopSafely()) {
            this.mViewPager.setCurrentItem(BannerUtils.getOriginalPosition(list.size()), false);
        }
        this.mViewPager.unregisterOnPageChangeCallback(this.mOnPageChangeCallback);
        this.mViewPager.registerOnPageChangeCallback(this.mOnPageChangeCallback);
        this.mViewPager.setOrientation(bannerOptions.getOrientation());
        this.mViewPager.setOffscreenPageLimit(bannerOptions.getOffScreenPageLimit());
        this.initRevealWidth(bannerOptions);
        this.initPageStyle(bannerOptions.getPageStyle());
        this.startLoop();
    }

    private void initRevealWidth(BannerOptions bannerOptions) {
        int rightRevealWidth = bannerOptions.getRightRevealWidth();
        int leftRevealWidth = bannerOptions.getLeftRevealWidth();
        if (leftRevealWidth != -1000 || rightRevealWidth != -1000) {
            RecyclerView recyclerView = (RecyclerView)this.mViewPager.getChildAt(0);
            int orientation = bannerOptions.getOrientation();
            int padding2 = bannerOptions.getPageMargin() + rightRevealWidth;
            int padding1 = bannerOptions.getPageMargin() + leftRevealWidth;
            if (orientation == 0) {
                recyclerView.setPadding(padding1, 0, padding2, 0);
            } else if (orientation == 1) {
                recyclerView.setPadding(0, padding1, 0, padding2);
            }
            recyclerView.setClipToPadding(false);
        }
        this.mBannerManager.createMarginTransformer();
    }

    private void initPageStyle(int pageStyle) {
        float pageScale = this.mBannerManager.getBannerOptions().getPageScale();
        if (pageStyle == 4) {
            this.mBannerManager.setMultiPageStyle(true, pageScale);
        } else if (pageStyle == 8) {
            this.mBannerManager.setMultiPageStyle(false, pageScale);
        }
    }

    private void resetCurrentItem(int item) {
        if (this.isCanLoopSafely()) {
            this.mViewPager.setCurrentItem(BannerUtils.getOriginalPosition(this.mBannerPagerAdapter.getListSize()) + item, false);
        } else {
            this.mViewPager.setCurrentItem(item, false);
        }
    }

    private void refreshIndicator(List<? extends T> data) {
        this.setIndicatorValues(data);
        this.mBannerManager.getBannerOptions().getIndicatorOptions().setCurrentPosition(BannerUtils.getRealPosition(this.mViewPager.getCurrentItem(), data.size()));
        this.mIndicatorView.notifyDataChanged();
    }

    private int getInterval() {
        return this.mBannerManager.getBannerOptions().getInterval();
    }

    private boolean isAutoPlay() {
        return this.mBannerManager.getBannerOptions().isAutoPlay();
    }

    private boolean isCanLoopSafely() {
        return this.mBannerManager != null && this.mBannerManager.getBannerOptions() != null && this.mBannerManager.getBannerOptions().isCanLoop() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        bundle.putInt(KEY_CURRENT_POSITION, this.currentPosition);
        bundle.putBoolean(KEY_IS_CUSTOM_INDICATOR, this.isCustomIndicator);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        super.onRestoreInstanceState(superState);
        this.currentPosition = bundle.getInt(KEY_CURRENT_POSITION);
        this.isCustomIndicator = bundle.getBoolean(KEY_IS_CUSTOM_INDICATOR);
        this.setCurrentItem(this.currentPosition, false);
    }

    public List<T> getData() {
        if (this.mBannerPagerAdapter != null) {
            return this.mBannerPagerAdapter.getData();
        }
        return Collections.emptyList();
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
            this.isLooping = true;
        }
    }

    public void startLoopNow() {
        if (!this.isLooping && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.post(this.mRunnable);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T> setAdapter(BaseBannerAdapter<T> adapter) {
        this.mBannerPagerAdapter = adapter;
        return this;
    }

    public BaseBannerAdapter<T> getAdapter() {
        return this.mBannerPagerAdapter;
    }

    public BannerViewPager<T> setRoundCorner(int radius) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBannerManager.getBannerOptions().setRoundRectRadius(radius);
        } else {
            this.setRoundCorner(radius, radius, radius, radius);
        }
        return this;
    }

    public BannerViewPager<T> setRoundCorner(int topLeftRadius, int topRightRadius, int bottomLeftRadius, int bottomRightRadius) {
        this.mRadiusRectF = new RectF();
        this.mRadiusPath = new Path();
        this.mBannerManager.getBannerOptions().setRoundRectRadius(topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius);
        return this;
    }

    public BannerViewPager<T> setAutoPlay(boolean autoPlay) {
        this.mBannerManager.getBannerOptions().setAutoPlay(autoPlay);
        if (this.isAutoPlay()) {
            this.mBannerManager.getBannerOptions().setCanLoop(true);
        }
        return this;
    }

    public BannerViewPager<T> setCanLoop(boolean canLoop) {
        this.mBannerManager.getBannerOptions().setCanLoop(canLoop);
        if (!canLoop) {
            this.mBannerManager.getBannerOptions().setAutoPlay(false);
        }
        return this;
    }

    public BannerViewPager<T> setInterval(int interval) {
        this.mBannerManager.getBannerOptions().setInterval(interval);
        return this;
    }

    public BannerViewPager<T> setPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mViewPager.setPageTransformer(transformer);
        }
        return this;
    }

    public BannerViewPager<T> addPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mBannerManager.addTransformer(transformer);
        }
        return this;
    }

    public void removeTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mBannerManager.removeTransformer(transformer);
        }
    }

    public void removeDefaultPageTransformer() {
        this.mBannerManager.removeDefaultPageTransformer();
    }

    public void removeMarginPageTransformer() {
        this.mBannerManager.removeMarginPageTransformer();
    }

    public BannerViewPager<T> setPageMargin(int pageMargin) {
        this.mBannerManager.setPageMargin(pageMargin);
        return this;
    }

    public BannerViewPager<T> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T> setScrollDuration(int scrollDuration) {
        this.mBannerManager.getBannerOptions().setScrollDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderColor(normalColor, checkedColor);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderRadius(int radius) {
        this.setIndicatorSliderRadius(radius, radius);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderRadius(int normalRadius, int checkedRadius) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderWidth(normalRadius * 2, checkedRadius * 2);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderWidth(int indicatorWidth) {
        this.setIndicatorSliderWidth(indicatorWidth, indicatorWidth);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderWidth(int normalWidth, int checkWidth) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderWidth(normalWidth, checkWidth);
        return this;
    }

    public BannerViewPager<T> setIndicatorHeight(int indicatorHeight) {
        this.mBannerManager.getBannerOptions().setIndicatorHeight(indicatorHeight);
        return this;
    }

    public BannerViewPager<T> setIndicatorSliderGap(int indicatorGap) {
        this.mBannerManager.getBannerOptions().setIndicatorGap(indicatorGap);
        return this;
    }

    public BannerViewPager<T> setIndicatorVisibility(int visibility) {
        this.mBannerManager.getBannerOptions().setIndicatorVisibility(visibility);
        return this;
    }

    public BannerViewPager<T> setIndicatorGravity(int gravity) {
        this.mBannerManager.getBannerOptions().setIndicatorGravity(gravity);
        return this;
    }

    public BannerViewPager<T> setIndicatorSlideMode(int slideMode) {
        this.mBannerManager.getBannerOptions().setIndicatorSlideMode(slideMode);
        return this;
    }

    public BannerViewPager<T> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.isCustomIndicator = true;
            this.mIndicatorView = customIndicator;
        }
        return this;
    }

    public BannerViewPager<T> setIndicatorStyle(int indicatorStyle) {
        this.mBannerManager.getBannerOptions().setIndicatorStyle(indicatorStyle);
        return this;
    }

    public void create(List<T> data) {
        if (this.mBannerPagerAdapter == null) {
            throw new NullPointerException("You must set adapter for BannerViewPager");
        }
        this.mBannerPagerAdapter.setData(data);
        this.initBannerData();
    }

    public void create() {
        this.create(new ArrayList());
    }

    public BannerViewPager<T> setOrientation(int orientation) {
        this.mBannerManager.getBannerOptions().setOrientation(orientation);
        return this;
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        if (this.isCanLoopSafely()) {
            int pageSize = this.mBannerPagerAdapter.getListSize();
            int currentItem = this.mViewPager.getCurrentItem();
            boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
            int realPosition = BannerUtils.getRealPosition(currentItem, pageSize);
            if (currentItem != index) {
                if (index == 0 && realPosition == pageSize - 1) {
                    this.mViewPager.addItemDecoration(decor, currentItem + 1);
                } else if (realPosition == 0 && index == pageSize - 1) {
                    this.mViewPager.addItemDecoration(decor, currentItem - 1);
                } else {
                    this.mViewPager.addItemDecoration(decor, currentItem + (index - realPosition));
                }
            }
        } else {
            this.mViewPager.addItemDecoration(decor, index);
        }
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mViewPager.addItemDecoration(decor);
    }

    public void refreshData(List<? extends T> list) {
        this.post(() -> {
            if (this.isAttachedToWindow() && list != null && this.mBannerPagerAdapter != null) {
                this.stopLoop();
                this.mBannerPagerAdapter.setData(list);
                this.mBannerPagerAdapter.notifyDataSetChanged();
                this.resetCurrentItem(this.getCurrentItem());
                this.refreshIndicator(list);
                this.startLoop();
            }
        });
    }

    public void addData(List<? extends T> list) {
        if (this.isAttachedToWindow() && list != null && this.mBannerPagerAdapter != null) {
            List<T> data = this.mBannerPagerAdapter.getData();
            data.addAll(list);
            this.mBannerPagerAdapter.notifyDataSetChanged();
            this.resetCurrentItem(this.getCurrentItem());
            this.refreshIndicator(data);
        }
    }

    public void removeItem(int index) {
        List<T> data = this.mBannerPagerAdapter.getData();
        if (this.isAttachedToWindow() && index >= 0 && index < data.size()) {
            data.remove(index);
            this.mBannerPagerAdapter.notifyDataSetChanged();
            this.resetCurrentItem(this.getCurrentItem());
            this.refreshIndicator(data);
        }
    }

    public void insertItem(int index, T item) {
        List<T> data = this.mBannerPagerAdapter.getData();
        if (this.isAttachedToWindow() && index >= 0 && index <= data.size()) {
            data.add(index, item);
            this.mBannerPagerAdapter.notifyDataSetChanged();
            this.resetCurrentItem(this.getCurrentItem());
            this.refreshIndicator(data);
        }
    }

    public int getCurrentItem() {
        return this.currentPosition;
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.isCanLoopSafely()) {
            int pageSize = this.mBannerPagerAdapter.getListSize();
            item = item >= pageSize ? pageSize - 1 : item;
            int currentItem = this.mViewPager.getCurrentItem();
            boolean canLoop = this.mBannerManager.getBannerOptions().isCanLoop();
            int realPosition = BannerUtils.getRealPosition(currentItem, pageSize);
            if (currentItem != item) {
                if (item == 0 && realPosition == pageSize - 1) {
                    this.mViewPager.setCurrentItem(currentItem + 1, smoothScroll);
                } else if (realPosition == 0 && item == pageSize - 1) {
                    this.mViewPager.setCurrentItem(currentItem - 1, smoothScroll);
                } else {
                    this.mViewPager.setCurrentItem(currentItem + (item - realPosition), smoothScroll);
                }
            }
        } else {
            this.mViewPager.setCurrentItem(item, smoothScroll);
        }
    }

    public BannerViewPager<T> setPageStyle(int pageStyle) {
        return this.setPageStyle(pageStyle, 0.85f);
    }

    public BannerViewPager<T> setPageStyle(int pageStyle, float pageScale) {
        this.mBannerManager.getBannerOptions().setPageStyle(pageStyle);
        this.mBannerManager.getBannerOptions().setPageScale(pageScale);
        return this;
    }

    public BannerViewPager<T> setRevealWidth(int revealWidth) {
        this.setRevealWidth(revealWidth, revealWidth);
        return this;
    }

    public BannerViewPager<T> setRevealWidth(int leftRevealWidth, int rightRevealWidth) {
        this.mBannerManager.getBannerOptions().setRightRevealWidth(rightRevealWidth);
        this.mBannerManager.getBannerOptions().setLeftRevealWidth(leftRevealWidth);
        return this;
    }

    public BannerViewPager<T> setOffScreenPageLimit(int offScreenPageLimit) {
        this.mBannerManager.getBannerOptions().setOffScreenPageLimit(offScreenPageLimit);
        return this;
    }

    public BannerViewPager<T> setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mBannerManager.getBannerOptions().setIndicatorMargin(left, top, right, bottom);
        return this;
    }

    public BannerViewPager<T> setUserInputEnabled(boolean userInputEnabled) {
        this.mBannerManager.getBannerOptions().setUserInputEnabled(userInputEnabled);
        this.mViewPager.setUserInputEnabled(userInputEnabled);
        return this;
    }

    public BannerViewPager<T> registerOnPageChangeCallback(ViewPager2.OnPageChangeCallback onPageChangeCallback) {
        this.onPageChangeCallback = onPageChangeCallback;
        return this;
    }

    public BannerViewPager<T> setLifecycleRegistry(Lifecycle lifecycleRegistry) {
        lifecycleRegistry.addObserver((LifecycleObserver)this);
        return this;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        this.stopLoop();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        this.startLoop();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.stopLoop();
    }

    public BannerViewPager<T> disallowParentInterceptDownEvent(boolean disallowParentInterceptDownEvent) {
        this.mBannerManager.getBannerOptions().setDisallowParentInterceptDownEvent(disallowParentInterceptDownEvent);
        return this;
    }

    public BannerViewPager<T> setRTLMode(boolean rtlMode) {
        this.mViewPager.setLayoutDirection(rtlMode ? 1 : 0);
        this.mBannerManager.getBannerOptions().setRtl(rtlMode);
        return this;
    }

    public BannerViewPager<T> stopLoopWhenDetachedFromWindow(boolean stopLoopWhenDetachedFromWindow) {
        this.mBannerManager.getBannerOptions().setStopLoopWhenDetachedFromWindow(stopLoopWhenDetachedFromWindow);
        return this;
    }

    public BannerViewPager<T> showIndicatorWhenOneItem(boolean showIndicatorWhenOneItem) {
        this.mBannerManager.getBannerOptions().showIndicatorWhenOneItem(showIndicatorWhenOneItem);
        return this;
    }

    @Deprecated
    public BannerViewPager<T> disallowInterceptTouchEvent(boolean disallowIntercept) {
        this.mBannerManager.getBannerOptions().setDisallowParentInterceptDownEvent(disallowIntercept);
        return this;
    }

    @Deprecated
    public BannerViewPager<T> setRoundRect(int radius) {
        return this.setRoundCorner(radius);
    }

    @Deprecated
    public BannerViewPager<T> setRoundRect(int topLeftRadius, int topRightRadius, int bottomLeftRadius, int bottomRightRadius) {
        return this.setRoundCorner(topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius);
    }

    public static interface OnPageClickListener {
        public void onPageClick(View var1, int var2);
    }
}

