/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.zhpan.bannerview.BaseBannerAdapter;
import com.zhpan.bannerview.BaseViewHolder;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.manager.BannerManager;
import com.zhpan.bannerview.manager.BannerOptions;
import com.zhpan.bannerview.provider.ScrollDurationManger;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.OverlapPageTransformer;
import com.zhpan.bannerview.transform.ScaleInTransformer;
import com.zhpan.bannerview.utils.BannerUtils;
import com.zhpan.indicator.IndicatorView;
import com.zhpan.indicator.base.IIndicator;
import java.util.ArrayList;
import java.util.List;

public class BannerViewPager<T, VH extends BaseViewHolder<T>>
extends RelativeLayout {
    private int currentPosition;
    private boolean isCustomIndicator;
    private boolean isLooping;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    private RelativeLayout mIndicatorLayout;
    private ViewPager2 mViewPager;
    private BannerManager mBannerManager;
    private Handler mHandler = new Handler();
    private BaseBannerAdapter<T, VH> mBannerPagerAdapter;
    private ViewPager2.OnPageChangeCallback onPageChangeCallback;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            BannerViewPager.this.handlePosition();
        }
    };
    private int startX;
    private int startY;
    private CompositePageTransformer mCompositePageTransformer;
    private MarginPageTransformer mMarginPageTransformer;
    private ViewPager2.PageTransformer mPageTransformer;
    private ViewPager2.OnPageChangeCallback mOnPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            super.onPageScrolled(position, positionOffset, positionOffsetPixels);
            int listSize = BannerViewPager.this.mBannerPagerAdapter.getListSize();
            int realPosition = BannerUtils.getRealPosition(BannerViewPager.this.isCanLoop(), position, listSize);
            if (listSize > 0) {
                if (BannerViewPager.this.onPageChangeCallback != null) {
                    BannerViewPager.this.onPageChangeCallback.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                }
                if (BannerViewPager.this.mIndicatorView != null) {
                    BannerViewPager.this.mIndicatorView.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                }
            }
        }

        public void onPageSelected(int position) {
            super.onPageSelected(position);
            int size = BannerViewPager.this.mBannerPagerAdapter.getListSize();
            BannerViewPager.this.currentPosition = BannerUtils.getRealPosition(BannerViewPager.this.isCanLoop(), position, size);
            if (size > 0 && BannerViewPager.this.isCanLoop() && position == 0 || position == 499) {
                BannerViewPager.this.setCurrentItem(BannerViewPager.this.currentPosition, false);
            }
            if (BannerViewPager.this.onPageChangeCallback != null) {
                BannerViewPager.this.onPageChangeCallback.onPageSelected(BannerViewPager.this.currentPosition);
            }
            if (BannerViewPager.this.mIndicatorView != null) {
                BannerViewPager.this.mIndicatorView.onPageSelected(BannerViewPager.this.currentPosition);
            }
        }

        public void onPageScrollStateChanged(int state) {
            super.onPageScrollStateChanged(state);
            if (BannerViewPager.this.mIndicatorView != null) {
                BannerViewPager.this.mIndicatorView.onPageScrollStateChanged(state);
            }
            if (BannerViewPager.this.onPageChangeCallback != null) {
                BannerViewPager.this.onPageChangeCallback.onPageScrollStateChanged(state);
            }
        }
    };

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mCompositePageTransformer = new CompositePageTransformer();
        this.mBannerManager = new BannerManager();
        this.mBannerManager.initAttrs(context, attrs);
        this.initView();
    }

    private void initView() {
        BannerViewPager.inflate((Context)this.getContext(), (int)R.layout.bvp_layout, (ViewGroup)this);
        this.mViewPager = (ViewPager2)this.findViewById(R.id.vp_main);
        this.mIndicatorLayout = (RelativeLayout)this.findViewById(R.id.bvp_layout_indicator);
        this.mViewPager.setPageTransformer((ViewPager2.PageTransformer)this.mCompositePageTransformer);
    }

    protected void onDetachedFromWindow() {
        this.stopLoop();
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startLoop();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.isLooping = true;
                this.stopLoop();
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.isLooping = false;
                this.startLoop();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mViewPager.isUserInputEnabled() || this.mBannerPagerAdapter.getData().size() <= 1) {
            return super.onInterceptTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                this.startX = (int)ev.getX();
                this.startY = (int)ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                int endX = (int)ev.getX();
                int endY = (int)ev.getY();
                int disX = Math.abs(endX - this.startX);
                int disY = Math.abs(endY - this.startY);
                int orientation = this.mBannerManager.getBannerOptions().getOrientation();
                if (orientation == 1) {
                    this.onVerticalActionMove(endY, disX, disY);
                    break;
                }
                if (orientation != 0) break;
                this.onHorizontalActionMove(endX, disX, disY);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void onVerticalActionMove(int endY, int disX, int disY) {
        if (disY > disX) {
            if (!this.isCanLoop()) {
                if (this.currentPosition == 0 && endY - this.startY > 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else if (this.currentPosition == this.getData().size() - 1 && endY - this.startY < 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else if (disX > disY) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
    }

    private void onHorizontalActionMove(int endX, int disX, int disY) {
        if (disX > disY) {
            if (!this.isCanLoop()) {
                if (this.currentPosition == 0 && endX - this.startX > 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else if (this.currentPosition == this.getData().size() - 1 && endX - this.startX < 0) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else if (disY > disX) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
    }

    private void handlePosition() {
        if (this.mBannerPagerAdapter.getListSize() > 1 && this.isAutoPlay()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
        }
    }

    private void initBannerData() {
        List<T> list = this.mBannerPagerAdapter.getData();
        if (list != null) {
            this.setIndicatorValues(list);
            this.setupViewPager(list);
            this.initRoundCorner();
        }
    }

    private void setIndicatorValues(List<T> list) {
        this.mIndicatorLayout.setVisibility(this.mBannerManager.getBannerOptions().getIndicatorVisibility());
        BannerOptions bannerOptions = this.mBannerManager.getBannerOptions();
        bannerOptions.resetIndicatorOptions();
        if (this.isCustomIndicator && null != this.mIndicatorView) {
            this.initIndicator(this.mIndicatorView);
        } else {
            this.initIndicator((IIndicator)new IndicatorView(this.getContext()));
        }
        this.mIndicatorView.setIndicatorOptions(bannerOptions.getIndicatorOptions());
        bannerOptions.getIndicatorOptions().setPageSize(list.size());
        this.mIndicatorView.notifyDataChanged();
    }

    private void initIndicator(IIndicator indicatorView) {
        this.mIndicatorView = indicatorView;
        if (((View)this.mIndicatorView).getParent() == null) {
            this.mIndicatorLayout.removeAllViews();
            this.mIndicatorLayout.addView((View)this.mIndicatorView);
            this.initIndicatorViewMargin();
            this.initIndicatorGravity();
        }
    }

    private void initIndicatorGravity() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((View)this.mIndicatorView).getLayoutParams();
        switch (this.mBannerManager.getBannerOptions().getIndicatorGravity()) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 2: {
                layoutParams.addRule(9);
                break;
            }
            case 4: {
                layoutParams.addRule(11);
            }
        }
    }

    private void initIndicatorViewMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)((View)this.mIndicatorView).getLayoutParams();
        BannerOptions.IndicatorMargin indicatorMargin = this.mBannerManager.getBannerOptions().getIndicatorMargin();
        if (indicatorMargin == null) {
            int dp10 = BannerUtils.dp2px(10.0f);
            layoutParams.setMargins(dp10, dp10, dp10, dp10);
        } else {
            layoutParams.setMargins(indicatorMargin.getLeft(), indicatorMargin.getTop(), indicatorMargin.getRight(), indicatorMargin.getBottom());
        }
    }

    private void initRoundCorner() {
        int roundCorner = this.mBannerManager.getBannerOptions().getRoundRectRadius();
        if (roundCorner > 0 && Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundRect(roundCorner);
        }
    }

    private void setupViewPager(List<T> list) {
        if (this.mBannerPagerAdapter == null) {
            throw new NullPointerException("You must set adapter for BannerViewPager");
        }
        BannerOptions bannerOptions = this.mBannerManager.getBannerOptions();
        if (bannerOptions.getScrollDuration() != 0) {
            ScrollDurationManger.reflectLayoutManager(this.mViewPager, bannerOptions.getScrollDuration());
        }
        this.currentPosition = 0;
        this.mBannerPagerAdapter.setCanLoop(this.isCanLoop());
        this.mBannerPagerAdapter.setPageClickListener(this.mOnPageClickListener);
        this.mViewPager.setAdapter(this.mBannerPagerAdapter);
        if (list.size() > 1 && this.isCanLoop()) {
            this.mViewPager.setCurrentItem(250 - 250 % list.size() + 1, false);
        }
        this.mViewPager.unregisterOnPageChangeCallback(this.mOnPageChangeCallback);
        this.mViewPager.registerOnPageChangeCallback(this.mOnPageChangeCallback);
        this.mViewPager.setOrientation(bannerOptions.getOrientation());
        this.mViewPager.setUserInputEnabled(bannerOptions.isUserInputEnabled());
        this.mViewPager.setOffscreenPageLimit(bannerOptions.getOffScreenPageLimit());
        this.initPageStyle();
        this.startLoop();
    }

    private void initPageStyle() {
        switch (this.mBannerManager.getBannerOptions().getPageStyle()) {
            case 2: {
                this.setMultiPageStyle(false, 0.999f);
                break;
            }
            case 4: {
                this.setMultiPageStyle(true, this.mBannerManager.getBannerOptions().getPageScale());
                break;
            }
            case 8: {
                this.setMultiPageStyle(false, this.mBannerManager.getBannerOptions().getPageScale());
            }
        }
    }

    private void setMultiPageStyle(boolean overlap, float scale) {
        RecyclerView recyclerView = (RecyclerView)this.mViewPager.getChildAt(0);
        BannerOptions bannerOptions = this.mBannerManager.getBannerOptions();
        int orientation = bannerOptions.getOrientation();
        int padding = bannerOptions.getPageMargin() + bannerOptions.getRevealWidth();
        if (orientation == 0) {
            recyclerView.setPadding(padding, 0, padding, 0);
        } else if (orientation == 1) {
            recyclerView.setPadding(0, padding, 0, padding);
        }
        recyclerView.setClipToPadding(false);
        if (this.mPageTransformer != null) {
            this.mCompositePageTransformer.removeTransformer(this.mPageTransformer);
        }
        this.mPageTransformer = overlap && Build.VERSION.SDK_INT >= 21 ? new OverlapPageTransformer(orientation, scale, 0.0f, 1.0f, 0.0f) : new ScaleInTransformer(scale);
        this.addPageTransformer(this.mPageTransformer);
    }

    private int getInterval() {
        return this.mBannerManager.getBannerOptions().getInterval();
    }

    private boolean isAutoPlay() {
        return this.mBannerManager.getBannerOptions().isAutoPlay();
    }

    private boolean isCanLoop() {
        return this.mBannerManager.getBannerOptions().isCanLoop();
    }

    public List<T> getData() {
        return this.mBannerPagerAdapter.getData();
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T, VH> setAdapter(BaseBannerAdapter<T, VH> adapter) {
        this.mBannerPagerAdapter = adapter;
        return this;
    }

    public BaseBannerAdapter<T, VH> getAdapter() {
        return this.mBannerPagerAdapter;
    }

    public BannerViewPager<T, VH> setRoundCorner(int radius) {
        this.mBannerManager.getBannerOptions().setRoundRectRadius(radius);
        return this;
    }

    public BannerViewPager<T, VH> setRoundRect(int radius) {
        this.setRoundCorner(radius);
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.mBannerManager.getBannerOptions().setAutoPlay(autoPlay);
        if (this.isAutoPlay()) {
            this.mBannerManager.getBannerOptions().setCanLoop(true);
        }
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.mBannerManager.getBannerOptions().setCanLoop(canLoop);
        if (!canLoop) {
            this.mBannerManager.getBannerOptions().setAutoPlay(false);
        }
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.mBannerManager.getBannerOptions().setInterval(interval);
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mViewPager.setPageTransformer(transformer);
        }
        return this;
    }

    public BannerViewPager<T, VH> addPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mCompositePageTransformer.addTransformer(transformer);
        }
        return this;
    }

    public void removeTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        if (transformer != null) {
            this.mCompositePageTransformer.removeTransformer(transformer);
        }
    }

    public BannerViewPager<T, VH> setPageMargin(int pageMargin) {
        this.mBannerManager.getBannerOptions().setPageMargin(pageMargin);
        if (this.mMarginPageTransformer != null) {
            this.mCompositePageTransformer.removeTransformer((ViewPager2.PageTransformer)this.mMarginPageTransformer);
        }
        this.mMarginPageTransformer = new MarginPageTransformer(pageMargin);
        this.mCompositePageTransformer.addTransformer((ViewPager2.PageTransformer)this.mMarginPageTransformer);
        return this;
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mBannerManager.getBannerOptions().setScrollDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderColor(normalColor, checkedColor);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderRadius(int radius) {
        this.setIndicatorSliderRadius(radius, radius);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderRadius(int normalRadius, int checkedRadius) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderWidth(normalRadius * 2, checkedRadius * 2);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderWidth(int indicatorWidth) {
        this.setIndicatorSliderWidth(indicatorWidth, indicatorWidth);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderWidth(int normalWidth, int checkWidth) {
        this.mBannerManager.getBannerOptions().setIndicatorSliderWidth(normalWidth, checkWidth);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorHeight(int indicatorHeight) {
        this.mBannerManager.getBannerOptions().setIndicatorHeight(indicatorHeight);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSliderGap(int indicatorGap) {
        this.mBannerManager.getBannerOptions().setIndicatorGap(indicatorGap);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorVisibility(int visibility) {
        this.mBannerManager.getBannerOptions().setIndicatorVisibility(visibility);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.mBannerManager.getBannerOptions().setIndicatorGravity(gravity);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSlideMode(int slideMode) {
        this.mBannerManager.getBannerOptions().setIndicatorSlideMode(slideMode);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.isCustomIndicator = true;
            this.mIndicatorView = customIndicator;
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorStyle(int indicatorStyle) {
        this.mBannerManager.getBannerOptions().setIndicatorStyle(indicatorStyle);
        return this;
    }

    public void create(List<T> data) {
        if (this.mBannerPagerAdapter == null) {
            throw new NullPointerException("You must set adapter for BannerViewPager");
        }
        this.mBannerPagerAdapter.setData(data);
        this.initBannerData();
    }

    public void create() {
        this.create(new ArrayList());
    }

    public BannerViewPager<T, VH> setOrientation(int orientation) {
        this.mBannerManager.getBannerOptions().setOrientation(orientation);
        return this;
    }

    public void refreshData(List<T> list) {
        if (list != null && this.mBannerPagerAdapter != null) {
            this.stopLoop();
            this.mBannerPagerAdapter.setData(list);
            this.mBannerPagerAdapter.notifyDataSetChanged();
            this.setCurrentItem(this.getCurrentItem(), false);
            this.setIndicatorValues(list);
            this.mBannerManager.getBannerOptions().getIndicatorOptions().setCurrentPosition(BannerUtils.getRealPosition(this.isCanLoop(), this.mViewPager.getCurrentItem(), list.size()));
            this.mIndicatorView.notifyDataChanged();
            this.startLoop();
        }
    }

    public int getCurrentItem() {
        return this.currentPosition;
    }

    public void setCurrentItem(int item) {
        if (this.isCanLoop() && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mViewPager.setCurrentItem(250 - 250 % this.mBannerPagerAdapter.getListSize() + 1 + item);
        } else {
            this.mViewPager.setCurrentItem(item);
        }
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.isCanLoop() && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mViewPager.setCurrentItem(250 - 250 % this.mBannerPagerAdapter.getListSize() + 1 + item, smoothScroll);
        } else {
            this.mViewPager.setCurrentItem(item, smoothScroll);
        }
    }

    public BannerViewPager<T, VH> setPageStyle(int pageStyle) {
        return this.setPageStyle(pageStyle, 0.85f);
    }

    public BannerViewPager<T, VH> setPageStyle(int pageStyle, float pageScale) {
        this.mBannerManager.getBannerOptions().setPageStyle(pageStyle);
        this.mBannerManager.getBannerOptions().setPageScale(pageScale);
        return this;
    }

    public BannerViewPager<T, VH> setRevealWidth(int revealWidth) {
        this.mBannerManager.getBannerOptions().setRevealWidth(revealWidth);
        return this;
    }

    public BannerViewPager<T, VH> setOffScreenPageLimit(int offScreenPageLimit) {
        this.mBannerManager.getBannerOptions().setOffScreenPageLimit(offScreenPageLimit);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mBannerManager.getBannerOptions().setIndicatorMargin(left, top, right, bottom);
        return this;
    }

    public BannerViewPager<T, VH> setUserInputEnabled(boolean userInputEnabled) {
        this.mBannerManager.getBannerOptions().setUserInputEnabled(userInputEnabled);
        return this;
    }

    public BannerViewPager<T, VH> registerOnPageChangeCallback(ViewPager2.OnPageChangeCallback onPageChangeCallback) {
        this.onPageChangeCallback = onPageChangeCallback;
        return this;
    }

    @Deprecated
    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.mIndicatorLayout.setVisibility(showIndicator ? 0 : 8);
        return this;
    }

    @Deprecated
    public BannerViewPager<T, VH> disableTouchScroll(boolean disableTouchScroll) {
        this.mBannerManager.getBannerOptions().setUserInputEnabled(!disableTouchScroll);
        return this;
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

