/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.provider.BannerScroller;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;

public class CatchViewPager
extends ViewPager {
    private ArrayList<Integer> mArrayList = new ArrayList();
    private SparseIntArray mSparseIntArray = new SparseIntArray();
    private boolean mOverlapStyle = false;
    private BannerScroller mBannerScroller;
    private boolean disableTouchScroll;
    private boolean firstLayout = true;

    public CatchViewPager(Context context) {
        this(context, null);
    }

    public CatchViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.hookScroller();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            if (this.disableTouchScroll) {
                return false;
            }
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mOverlapStyle) {
            if (i == 0 || this.mSparseIntArray.size() != childCount) {
                this.mArrayList.clear();
                this.mSparseIntArray.clear();
                int viewCenterX = this.getViewCenterX((View)this);
                for (int index = 0; index < childCount; ++index) {
                    int indexAbs = Math.abs(viewCenterX - this.getViewCenterX(this.getChildAt(index)));
                    this.mArrayList.add(++indexAbs);
                    this.mSparseIntArray.append(indexAbs, index);
                }
                Collections.sort(this.mArrayList);
            }
            return this.mSparseIntArray.get(this.mArrayList.get(childCount - 1 - i).intValue());
        }
        return super.getChildDrawingOrder(childCount, i);
    }

    private int getViewCenterX(View view) {
        int[] array = new int[2];
        view.getLocationOnScreen(array);
        return array[0] + view.getWidth() / 2;
    }

    public void setOverlapStyle(boolean overlapStyle) {
        this.mOverlapStyle = overlapStyle;
    }

    public void setScrollDuration(int scrollDuration) {
        this.mBannerScroller.setDuration(scrollDuration);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.disableTouchScroll) {
            return false;
        }
        return super.onTouchEvent(ev);
    }

    public void disableTouchScroll(boolean disableTouchScroll) {
        this.disableTouchScroll = disableTouchScroll;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.hookFirstLayout();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.firstLayout = false;
    }

    private void hookScroller() {
        try {
            this.mBannerScroller = new BannerScroller(this.getContext());
            this.mBannerScroller.setDuration(500);
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            mField.set((Object)this, (Object)this.mBannerScroller);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void hookFirstLayout() {
        try {
            Field mFirstLayout = ViewPager.class.getDeclaredField("mFirstLayout");
            mFirstLayout.setAccessible(true);
            mFirstLayout.set((Object)this, this.firstLayout);
            this.setCurrentItem(this.getCurrentItem());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void setFirstLayout(boolean firstLayout) {
        this.firstLayout = firstLayout;
    }
}

