/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.adapter.BannerPagerAdapter;
import com.zhpan.bannerview.enums.IndicatorSlideMode;
import com.zhpan.bannerview.enums.IndicatorStyle;
import com.zhpan.bannerview.enums.TransformerStyle;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.indicator.BaseIndicatorView;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.indicator.IndicatorFactory;
import com.zhpan.bannerview.provider.BannerScroller;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.PageTransformerFactory;
import com.zhpan.bannerview.utils.DpUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BannerViewPager<T, VH extends ViewHolder>
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    private ViewPager mViewPager;
    private List<T> mList;
    private int interval;
    private int currentPosition;
    private boolean isLooping;
    private boolean isCanLoop;
    private boolean isAutoPlay = false;
    private boolean showIndicator = true;
    public static final int START = 1;
    public static final int END = 2;
    public static final int CENTER = 0;
    private int gravity;
    private int indicatorNormalColor;
    private int indicatorCheckedColor;
    private int normalIndicatorWidth;
    private int checkedIndicatorWidth;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    RelativeLayout mRelativeLayout;
    private IndicatorStyle mIndicatorStyle = IndicatorStyle.CIRCLE;
    private HolderCreator<VH> holderCreator;
    private IndicatorSlideMode mIndicatorSlideMode = IndicatorSlideMode.SMOOTH;
    Handler mHandler = new Handler();
    Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (BannerViewPager.this.mList.size() > 1) {
                BannerViewPager.this.currentPosition = BannerViewPager.this.currentPosition % (BannerViewPager.this.mList.size() + 1) + 1;
                if (BannerViewPager.this.currentPosition == 1) {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, false);
                    BannerViewPager.this.mHandler.post(BannerViewPager.this.mRunnable);
                } else {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, true);
                    BannerViewPager.this.mHandler.postDelayed(BannerViewPager.this.mRunnable, (long)BannerViewPager.this.interval);
                }
            }
        }
    };
    private BannerScroller mScroller;
    public static final int DEFAULT_SCROLL_DURATION = 800;
    private int indicatorGap = 0;

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, context);
    }

    private void init(AttributeSet attrs, Context context) {
        this.initValues(attrs, context);
        this.initView();
        this.initScroller();
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_banner_view_pager, (ViewGroup)this);
        this.mViewPager = (ViewPager)view.findViewById(R.id.vp_main);
        this.mRelativeLayout = (RelativeLayout)view.findViewById(R.id.rl_indicator);
        this.mList = new ArrayList<T>();
    }

    private void initValues(AttributeSet attrs, Context context) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerViewPager);
            this.interval = typedArray.getInteger(R.styleable.BannerViewPager_interval, 3000);
            this.indicatorCheckedColor = typedArray.getColor(R.styleable.BannerViewPager_indicator_checked_color, Color.parseColor((String)"#8C18171C"));
            this.indicatorNormalColor = typedArray.getColor(R.styleable.BannerViewPager_indicator_normal_color, Color.parseColor((String)"#8C6C6D72"));
            this.indicatorGap = this.normalIndicatorWidth = (int)typedArray.getDimension(R.styleable.BannerViewPager_indicator_radius, (float)DpUtils.dp2px(8.0f));
            this.checkedIndicatorWidth = this.normalIndicatorWidth;
            this.isAutoPlay = typedArray.getBoolean(R.styleable.BannerViewPager_isAutoPlay, true);
            this.isCanLoop = typedArray.getBoolean(R.styleable.BannerViewPager_isCanLoop, true);
            this.gravity = typedArray.getInt(R.styleable.BannerViewPager_indicator_gravity, 0);
            typedArray.recycle();
        }
    }

    private void initScroller() {
        try {
            this.mScroller = new BannerScroller(this.mViewPager.getContext());
            this.mScroller.setDuration(800);
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            mField.set(this.mViewPager, (Object)this.mScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initData() {
        if (this.mList.size() > 0) {
            if (this.mIndicatorView == null && this.mList.size() > 1 && this.showIndicator) {
                this.initIndicator(this.getIndicatorView());
            }
            if (this.isCanLoop) {
                this.currentPosition = 1;
            }
            this.setupViewPager();
        }
    }

    private BaseIndicatorView getIndicatorView() {
        BaseIndicatorView indicatorView = IndicatorFactory.createIndicatorView(this.getContext(), this.mIndicatorStyle);
        indicatorView.setPageSize(this.mList.size());
        indicatorView.setIndicatorWidth(this.normalIndicatorWidth, this.normalIndicatorWidth);
        indicatorView.setIndicatorGap(this.indicatorGap);
        indicatorView.setCheckedColor(this.indicatorCheckedColor);
        indicatorView.setNormalColor(this.indicatorNormalColor);
        indicatorView.setSlideMode(this.mIndicatorSlideMode);
        indicatorView.invalidate();
        return indicatorView;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setTouchListener() {
        this.mViewPager.setOnTouchListener((v, event) -> {
            int action = event.getAction();
            switch (action) {
                case 0: 
                case 2: {
                    this.isLooping = true;
                    this.stopLoop();
                    break;
                }
                case 1: 
                case 3: {
                    this.isLooping = false;
                    this.startLoop();
                }
            }
            return false;
        });
    }

    private void initIndicator(View indicatorView) {
        this.mRelativeLayout.removeAllViews();
        this.mRelativeLayout.addView(indicatorView);
        this.mIndicatorView = (IIndicator)indicatorView;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)indicatorView.getLayoutParams();
        layoutParams.addRule(15);
        switch (this.gravity) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 1: {
                layoutParams.addRule(20);
                break;
            }
            case 2: {
                layoutParams.addRule(21);
            }
        }
    }

    private void setupViewPager() {
        if (this.holderCreator == null) {
            throw new NullPointerException("You must set HolderCreator for BannerViewPager");
        }
        BannerPagerAdapter<T, VH> bannerPagerAdapter = new BannerPagerAdapter<T, VH>(this.mList, this.holderCreator);
        bannerPagerAdapter.setPageClickListener(position -> {
            if (this.mOnPageClickListener != null) {
                int realPosition;
                int n = realPosition = this.isCanLoop ? position - 1 : position;
                if (realPosition < this.mList.size() && realPosition >= 0) {
                    this.mOnPageClickListener.onPageClick(realPosition);
                }
            }
        });
        bannerPagerAdapter.setCanLoop(this.isCanLoop);
        this.mViewPager.setAdapter(bannerPagerAdapter);
        this.mViewPager.setCurrentItem(this.currentPosition);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.startLoop();
        this.setTouchListener();
    }

    public void onPageSelected(int position) {
        this.currentPosition = position;
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageSelected(this.getRealPosition(position));
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrollStateChanged(state);
        }
        if (this.isCanLoop) {
            switch (state) {
                case 0: {
                    if (this.currentPosition == 0) {
                        this.mViewPager.setCurrentItem(this.mList.size(), false);
                        break;
                    }
                    if (this.currentPosition != this.mList.size() + 1) break;
                    this.mViewPager.setCurrentItem(1, false);
                    break;
                }
                case 1: {
                    if (this.currentPosition == this.mList.size() + 1) {
                        this.mViewPager.setCurrentItem(1, false);
                        break;
                    }
                    if (this.currentPosition != 0) break;
                    this.mViewPager.setCurrentItem(this.mList.size(), false);
                }
            }
        } else {
            this.mViewPager.setCurrentItem(this.currentPosition);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrolled(this.getRealPosition(position), positionOffset, positionOffsetPixels);
        }
    }

    private int getRealPosition(int position) {
        if (this.isCanLoop) {
            if (position == 0) {
                return this.mList.size() - 1;
            }
            if (position == this.mList.size() + 1) {
                return 0;
            }
            return --position;
        }
        return position;
    }

    private int toUnrealPosition(int position) {
        return this.isCanLoop ? (position < this.mList.size() ? ++position : this.mList.size()) : position;
    }

    public List<T> getList() {
        return this.mList;
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay && this.mList.size() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.interval);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T, VH> setHolderCreator(HolderCreator<VH> holderCreator) {
        this.holderCreator = holderCreator;
        return this;
    }

    public BannerViewPager<T, VH> setRoundCorner(int radius) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundCorner(radius);
        }
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
        if (this.isAutoPlay) {
            this.isCanLoop = true;
        }
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
        if (!canLoop) {
            this.isAutoPlay = false;
        }
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformerStyle(TransformerStyle style) {
        this.mViewPager.setPageTransformer(true, new PageTransformerFactory().createPageTransformer(style));
        return this;
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mScroller.setDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.indicatorCheckedColor = checkedColor;
        this.indicatorNormalColor = normalColor;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int radius) {
        this.normalIndicatorWidth = radius * 2;
        this.checkedIndicatorWidth = radius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int normalRadius, int checkRadius) {
        this.normalIndicatorWidth = normalRadius * 2;
        this.checkedIndicatorWidth = checkRadius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int indicatorWidth) {
        this.normalIndicatorWidth = indicatorWidth;
        this.checkedIndicatorWidth = indicatorWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int normalWidth, int checkWidth) {
        this.normalIndicatorWidth = normalWidth;
        this.checkedIndicatorWidth = checkWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGap(int indicatorGap) {
        this.indicatorGap = indicatorGap;
        return this;
    }

    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.showIndicator = showIndicator;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSlideMode(IndicatorSlideMode slideMode) {
        this.mIndicatorSlideMode = slideMode;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.initIndicator((View)customIndicator);
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorStyle(IndicatorStyle indicatorStyle) {
        this.mIndicatorStyle = indicatorStyle;
        return this;
    }

    public void create(List<T> list) {
        if (list != null) {
            this.mList.clear();
            this.mList.addAll(list);
            this.initData();
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

