/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.zhpan.indicator.base.BaseIndicatorView;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001.B'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0014J\u001a\u0010$\u001a\u00020\u00002\b\b\u0001\u0010%\u001a\u00020\u00072\b\b\u0001\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007J&\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/zhpan/bannerview/indicator/DrawableIndicator;", "Lcom/zhpan/indicator/base/BaseIndicatorView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "checkCanResize", "", "mCheckedBitmap", "Landroid/graphics/Bitmap;", "mCheckedBitmapHeight", "mCheckedBitmapWidth", "mIndicatorPadding", "mIndicatorSize", "Lcom/zhpan/bannerview/indicator/DrawableIndicator$IndicatorSize;", "mNormalBitmap", "mNormalBitmapHeight", "mNormalBitmapWidth", "normalCanResize", "drawIcon", "", "canvas", "Landroid/graphics/Canvas;", "left", "top", "icon", "getBitmapFromVectorDrawable", "drawableId", "initIconSize", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setIndicatorDrawable", "normalDrawable", "checkedDrawable", "setIndicatorGap", "padding", "setIndicatorSize", "normalWidth", "normalHeight", "checkedWidth", "checkedHeight", "IndicatorSize", "bannerview_release"})
public final class DrawableIndicator
extends BaseIndicatorView {
    @Nullable
    private Bitmap mCheckedBitmap;
    @Nullable
    private Bitmap mNormalBitmap;
    private int mIndicatorPadding;
    private int mCheckedBitmapWidth;
    private int mCheckedBitmapHeight;
    private int mNormalBitmapWidth;
    private int mNormalBitmapHeight;
    @Nullable
    private IndicatorSize mIndicatorSize;
    private boolean normalCanResize;
    private boolean checkCanResize;

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNull((Object)context);
        super(context, attrs, defStyleAttr);
        this.normalCanResize = true;
        this.checkCanResize = true;
    }

    public /* synthetic */ DrawableIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int maxHeight = RangesKt.coerceAtLeast((int)this.mCheckedBitmapHeight, (int)this.mNormalBitmapHeight);
        int realWidth = this.mCheckedBitmapWidth + (this.mNormalBitmapWidth + this.mIndicatorPadding) * (this.getPageSize() - 1);
        this.setMeasuredDimension(realWidth, maxHeight);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.getPageSize() > 1 && this.mCheckedBitmap != null && this.mNormalBitmap != null && (n2 = 1) < (n = this.getPageSize() + 1)) {
            do {
                int i = n2++;
                int left = 0;
                int top = 0;
                Bitmap bitmap = this.mNormalBitmap;
                int index = i - 1;
                if (index < this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                } else if (index == this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mCheckedBitmapHeight / 2;
                    bitmap = this.mCheckedBitmap;
                } else {
                    left = (i - 1) * this.mIndicatorPadding + (i - 2) * this.mNormalBitmapWidth + this.mCheckedBitmapWidth;
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                }
                this.drawIcon(canvas, left, top, bitmap);
            } while (n2 < n);
        }
    }

    private final void drawIcon(Canvas canvas, int left, int top, Bitmap icon) {
        if (icon == null) {
            return;
        }
        canvas.drawBitmap(icon, (float)left, (float)top, null);
    }

    private final void initIconSize() {
        Bitmap bitmap;
        IndicatorSize matrix;
        IndicatorSize it;
        boolean bl;
        boolean bl2;
        IndicatorSize indicatorSize;
        IndicatorSize indicatorSize2;
        Bitmap it2;
        boolean bl3;
        boolean bl4;
        Bitmap bitmap2;
        Bitmap bitmap3 = this.mCheckedBitmap;
        if (bitmap3 != null) {
            bitmap2 = bitmap3;
            bl4 = false;
            bl3 = false;
            it2 = bitmap2;
            boolean bl5 = false;
            indicatorSize2 = this.mIndicatorSize;
            if (indicatorSize2 != null) {
                indicatorSize = indicatorSize2;
                bl2 = false;
                bl = false;
                it = indicatorSize;
                boolean bl6 = false;
                Object object = this.mCheckedBitmap;
                Intrinsics.checkNotNull((Object)object);
                if (object.isMutable() && this.checkCanResize) {
                    object = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)object);
                    Bitmap bitmap4 = object;
                    object = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)object);
                    bitmap4.setWidth(((IndicatorSize)object).getCheckedWidth());
                    object = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)object);
                    Object object2 = object;
                    object = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)object);
                    object2.setHeight(((IndicatorSize)object).getCheckedHeight());
                } else {
                    Bitmap bitmap5 = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap5);
                    int width = bitmap5.getWidth();
                    Bitmap bitmap6 = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap6);
                    int height = bitmap6.getHeight();
                    IndicatorSize indicatorSize3 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize3);
                    float scaleWidth = (float)indicatorSize3.getCheckedWidth() / (float)width;
                    IndicatorSize indicatorSize4 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize4);
                    float scaleHeight = (float)indicatorSize4.getCheckedHeight() / (float)height;
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    bitmap = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap);
                    this.mCheckedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            indicatorSize2 = this.mCheckedBitmap;
            Intrinsics.checkNotNull((Object)indicatorSize2);
            this.mCheckedBitmapWidth = indicatorSize2.getWidth();
            indicatorSize2 = this.mCheckedBitmap;
            Intrinsics.checkNotNull((Object)indicatorSize2);
            this.mCheckedBitmapHeight = indicatorSize2.getHeight();
        }
        bitmap3 = this.mNormalBitmap;
        if (bitmap3 != null) {
            bitmap2 = bitmap3;
            bl4 = false;
            bl3 = false;
            it2 = bitmap2;
            boolean bl7 = false;
            indicatorSize2 = this.mIndicatorSize;
            if (indicatorSize2 != null) {
                indicatorSize = indicatorSize2;
                bl2 = false;
                bl = false;
                it = indicatorSize;
                boolean bl8 = false;
                Object width = this.mNormalBitmap;
                Intrinsics.checkNotNull((Object)width);
                if (width.isMutable() && this.normalCanResize) {
                    width = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)width);
                    Bitmap bitmap7 = width;
                    width = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)width);
                    bitmap7.setWidth(((IndicatorSize)width).getNormalWidth());
                    width = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)width);
                    Object object = width;
                    width = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)width);
                    object.setHeight(((IndicatorSize)width).getNormalHeight());
                } else {
                    Bitmap height = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)height);
                    int width2 = height.getWidth();
                    Bitmap scaleWidth = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)scaleWidth);
                    int height2 = scaleWidth.getHeight();
                    IndicatorSize scaleHeight = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)scaleHeight);
                    float f = scaleHeight.getNormalWidth();
                    scaleHeight = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)scaleHeight);
                    float scaleWidth2 = f / (float)scaleHeight.getWidth();
                    matrix = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)matrix);
                    float f2 = matrix.getNormalHeight();
                    matrix = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)matrix);
                    float scaleHeight2 = f2 / (float)matrix.getHeight();
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth2, scaleHeight2);
                    bitmap = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap);
                    this.mNormalBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width2, (int)height2, (Matrix)matrix, (boolean)true);
                }
            }
            indicatorSize2 = this.mNormalBitmap;
            Intrinsics.checkNotNull((Object)indicatorSize2);
            this.mNormalBitmapWidth = indicatorSize2.getWidth();
            indicatorSize2 = this.mNormalBitmap;
            Intrinsics.checkNotNull((Object)indicatorSize2);
            this.mNormalBitmapHeight = indicatorSize2.getHeight();
        }
    }

    @NotNull
    public final DrawableIndicator setIndicatorDrawable(@DrawableRes int normalDrawable, @DrawableRes int checkedDrawable) {
        Context context;
        this.mNormalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalDrawable);
        this.mCheckedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)checkedDrawable);
        if (this.mNormalBitmap == null) {
            context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.mNormalBitmap = this.getBitmapFromVectorDrawable(context, normalDrawable);
            this.normalCanResize = false;
        }
        if (this.mCheckedBitmap == null) {
            context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.mCheckedBitmap = this.getBitmapFromVectorDrawable(context, checkedDrawable);
            this.checkCanResize = false;
        }
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
        this.mIndicatorSize = new IndicatorSize(normalWidth, normalHeight, checkedWidth, checkedHeight);
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorGap(int padding) {
        if (padding >= 0) {
            this.mIndicatorPadding = padding;
            this.postInvalidate();
        }
        return this;
    }

    private final Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = null;
        drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        Drawable drawable2 = drawable;
        if (drawable2 != null) {
            Drawable drawable3 = drawable2;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable3;
            boolean bl3 = false;
            if (Build.VERSION.SDK_INT < 21) {
                Intrinsics.checkNotNull((Object)drawable);
                drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
            }
            Intrinsics.checkNotNull((Object)drawable);
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        return null;
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/zhpan/bannerview/indicator/DrawableIndicator$IndicatorSize;", "", "normalWidth", "", "normalHeight", "checkedWidth", "checkedHeight", "(IIII)V", "getCheckedHeight", "()I", "setCheckedHeight", "(I)V", "getCheckedWidth", "setCheckedWidth", "getNormalHeight", "setNormalHeight", "getNormalWidth", "setNormalWidth", "bannerview_release"})
    public static final class IndicatorSize {
        private int normalWidth;
        private int normalHeight;
        private int checkedWidth;
        private int checkedHeight;

        public IndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
            this.normalWidth = normalWidth;
            this.normalHeight = normalHeight;
            this.checkedWidth = checkedWidth;
            this.checkedHeight = checkedHeight;
        }

        public final int getNormalWidth() {
            return this.normalWidth;
        }

        public final void setNormalWidth(int n) {
            this.normalWidth = n;
        }

        public final int getNormalHeight() {
            return this.normalHeight;
        }

        public final void setNormalHeight(int n) {
            this.normalHeight = n;
        }

        public final int getCheckedWidth() {
            return this.checkedWidth;
        }

        public final void setCheckedWidth(int n) {
            this.checkedWidth = n;
        }

        public final int getCheckedHeight() {
            return this.checkedHeight;
        }

        public final void setCheckedHeight(int n) {
            this.checkedHeight = n;
        }
    }
}

