/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;

public class BaseViewHolder<T>
extends RecyclerView.ViewHolder {
    private final SparseArray<View> mViews = new SparseArray();

    public BaseViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    @Deprecated
    public void bindData(T data, int position, int pageSize) {
    }

    public <V extends View> V findViewById(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (V)view;
    }

    public void setText(int viewId, CharSequence text) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText(text);
        }
    }

    public void setText(int viewId, @StringRes int textId) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText(textId);
        }
    }

    public void setTextColor(int viewId, @ColorInt int colorId) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(colorId);
        }
    }

    public void setOnClickListener(int viewId, View.OnClickListener clickListener) {
        this.findViewById(viewId).setOnClickListener(clickListener);
    }

    public void setBackgroundResource(int viewId, @DrawableRes int resId) {
        this.findViewById(viewId).setBackgroundResource(resId);
    }

    public void setBackgroundColor(int viewId, @ColorInt int colorId) {
        this.findViewById(viewId).setBackgroundColor(colorId);
    }

    public void setImageResource(@IdRes int viewId, @DrawableRes int resId) {
        Object view = this.findViewById(viewId);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(resId);
        }
    }
}

