/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.zhpan.bannerview.BannerViewPager;
import com.zhpan.bannerview.BaseViewHolder;
import com.zhpan.bannerview.utils.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBannerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>> {
    protected List<T> mList = new ArrayList<T>();
    private boolean isCanLoop;
    public static final int MAX_VALUE = 500;
    private BannerViewPager.OnPageClickListener mPageClickListener;

    @NonNull
    public final BaseViewHolder<T> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutId(viewType), parent, false);
        return this.createViewHolder(parent, itemView, viewType);
    }

    public final void onBindViewHolder(@NonNull BaseViewHolder<T> holder, final int position) {
        int realPosition = BannerUtils.getRealPosition(this.isCanLoop, position, this.getListSize());
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View clickedView) {
                if (BaseBannerAdapter.this.mPageClickListener != null) {
                    BaseBannerAdapter.this.mPageClickListener.onPageClick(clickedView, BannerUtils.getRealPosition(BaseBannerAdapter.this.isCanLoop, position, BaseBannerAdapter.this.getListSize()));
                }
            }
        });
        this.bindData(holder, this.mList.get(realPosition), realPosition, this.getListSize());
    }

    public final int getItemViewType(int position) {
        int realPosition = BannerUtils.getRealPosition(this.isCanLoop, position, this.getListSize());
        return this.getViewType(realPosition);
    }

    public final int getItemCount() {
        if (this.isCanLoop && this.getListSize() > 1) {
            return 500;
        }
        return this.getListSize();
    }

    List<T> getData() {
        return this.mList;
    }

    void setData(List<? extends T> list) {
        if (null != list) {
            this.mList.clear();
            this.mList.addAll(list);
        }
    }

    void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    void setPageClickListener(BannerViewPager.OnPageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    int getListSize() {
        return this.mList.size();
    }

    protected int getViewType(int position) {
        return 0;
    }

    public boolean isCanLoop() {
        return this.isCanLoop;
    }

    public BaseViewHolder<T> createViewHolder(@NonNull ViewGroup parent, View itemView, int viewType) {
        return new BaseViewHolder(itemView);
    }

    protected abstract void bindData(BaseViewHolder<T> var1, T var2, int var3, int var4);

    @LayoutRes
    public abstract int getLayoutId(int var1);
}

