/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.zhpan.bannerview.BannerViewPager;
import com.zhpan.bannerview.BaseViewHolder;
import com.zhpan.bannerview.utils.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBannerAdapter<T, VH extends BaseViewHolder<T>>
extends RecyclerView.Adapter<VH> {
    protected List<T> mList = new ArrayList<T>();
    private boolean isCanLoop;
    public static final int MAX_VALUE = 500;
    private BannerViewPager.OnPageClickListener mPageClickListener;

    @NonNull
    public final VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View inflate = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutId(viewType), parent, false);
        return this.createViewHolder(inflate, viewType);
    }

    public final void onBindViewHolder(@NonNull VH holder, final int position) {
        int realPosition = BannerUtils.getRealPosition(this.isCanLoop, position, this.mList.size());
        ((BaseViewHolder)((Object)holder)).itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseBannerAdapter.this.mPageClickListener != null) {
                    BaseBannerAdapter.this.mPageClickListener.onPageClick(BannerUtils.getRealPosition(BaseBannerAdapter.this.isCanLoop, position, BaseBannerAdapter.this.mList.size()));
                }
            }
        });
        this.onBind(holder, this.mList.get(realPosition), realPosition, this.mList.size());
    }

    public final int getItemViewType(int position) {
        int realPosition = BannerUtils.getRealPosition(this.isCanLoop, position, this.mList.size());
        return this.getViewType(realPosition);
    }

    public final int getItemCount() {
        if (this.isCanLoop && this.mList.size() > 1) {
            return 500;
        }
        return this.mList.size();
    }

    List<T> getData() {
        return this.mList;
    }

    void setData(List<T> list) {
        if (null != list) {
            this.mList.clear();
            this.mList.addAll(list);
        }
    }

    void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    void setPageClickListener(BannerViewPager.OnPageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    int getListSize() {
        return this.mList.size();
    }

    protected int getViewType(int position) {
        return 0;
    }

    protected abstract void onBind(VH var1, T var2, int var3, int var4);

    public abstract VH createViewHolder(View var1, int var2);

    public abstract int getLayoutId(int var1);
}

