/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator.drawer;

import android.graphics.Canvas;
import com.zhpan.bannerview.indicator.drawer.BaseDrawer;
import com.zhpan.bannerview.manager.IndicatorOptions;

public class DashDrawer
extends BaseDrawer {
    private float maxWidth;
    private float minWidth;

    DashDrawer(IndicatorOptions indicatorOptions) {
        super(indicatorOptions);
    }

    @Override
    public BaseDrawer.MeasureResult onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.maxWidth = Math.max(this.mIndicatorOptions.getNormalIndicatorWidth(), this.mIndicatorOptions.getCheckedIndicatorWidth());
        this.minWidth = Math.min(this.mIndicatorOptions.getNormalIndicatorWidth(), this.mIndicatorOptions.getCheckedIndicatorWidth());
        this.mMeasureResult.setMeasureResult(this.getMeasureWidth(), (int)this.mIndicatorOptions.getSliderHeight());
        return this.mMeasureResult;
    }

    private int getMeasureWidth() {
        int pageSize = this.mIndicatorOptions.getPageSize();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        return (int)((float)(pageSize - 1) * indicatorGap + this.maxWidth + (float)(pageSize - 1) * this.minWidth);
    }

    @Override
    public void onDraw(Canvas canvas) {
        this.drawIndicator(canvas);
    }

    private void drawIndicator(Canvas canvas) {
        int pageSize = this.mIndicatorOptions.getPageSize();
        if (pageSize > 1) {
            for (int i = 0; i < pageSize; ++i) {
                if (this.mIndicatorOptions.getSlideMode() == 2) {
                    this.smoothSlide(canvas, i);
                    continue;
                }
                this.normalSlide(canvas, i);
            }
        }
    }

    private void normalSlide(Canvas canvas, int i) {
        float normalIndicatorWidth = this.mIndicatorOptions.getNormalIndicatorWidth();
        int normalColor = this.mIndicatorOptions.getNormalColor();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        float sliderHeight = this.mIndicatorOptions.getSliderHeight();
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        if (normalIndicatorWidth == this.mIndicatorOptions.getCheckedIndicatorWidth()) {
            this.mPaint.setColor(normalColor);
            float left = (float)i * normalIndicatorWidth + (float)i * indicatorGap;
            canvas.drawRect(left, 0.0f, left + normalIndicatorWidth, sliderHeight, this.mPaint);
            this.drawSliderStyle(canvas);
        } else if (i < currentPosition) {
            this.mPaint.setColor(normalColor);
            float left = (float)i * this.minWidth + (float)i * indicatorGap;
            canvas.drawRect(left, 0.0f, left + this.minWidth, sliderHeight, this.mPaint);
        } else if (i == currentPosition) {
            this.mPaint.setColor(this.mIndicatorOptions.getCheckedColor());
            float left = (float)i * this.minWidth + (float)i * indicatorGap;
            canvas.drawRect(left, 0.0f, left + this.minWidth + (this.maxWidth - this.minWidth), sliderHeight, this.mPaint);
        } else {
            this.mPaint.setColor(normalColor);
            float left = (float)i * this.minWidth + (float)i * indicatorGap + (this.maxWidth - this.minWidth);
            canvas.drawRect(left, 0.0f, left + this.minWidth, sliderHeight, this.mPaint);
        }
    }

    private void smoothSlide(Canvas canvas, int i) {
        this.mPaint.setColor(this.mIndicatorOptions.getNormalColor());
        float left = (float)i * this.maxWidth + (float)i * this.mIndicatorOptions.getIndicatorGap() + (this.maxWidth - this.minWidth);
        canvas.drawRect(left, 0.0f, left + this.minWidth, this.mIndicatorOptions.getSliderHeight(), this.mPaint);
        this.drawSliderStyle(canvas);
    }

    private void drawSliderStyle(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorOptions.getCheckedColor());
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        float left = (float)currentPosition * this.maxWidth + (float)currentPosition * indicatorGap + (this.maxWidth + indicatorGap) * this.mIndicatorOptions.getSlideProgress();
        canvas.drawRect(left, 0.0f, left + this.maxWidth, this.mIndicatorOptions.getSliderHeight(), this.mPaint);
    }
}

