/*
 * Decompiled with CFR 0.152.
 */
package fftlib;

import com.zlw.main.recorderlib.utils.Logger;
import fftlib.ByteUtils;
import fftlib.FFT;

public class FftFactory {
    private static final String TAG = FftFactory.class.getSimpleName();
    private Level level = Level.Original;

    public FftFactory(Level level) {
    }

    public byte[] makeFftData(byte[] pcmData) {
        if (pcmData.length < 1024) {
            Logger.d(TAG, "makeFftData", new Object[0]);
            return null;
        }
        double[] doubles = ByteUtils.toHardDouble(ByteUtils.toShorts(pcmData));
        double[] fft = FFT.fft(doubles, 0);
        switch (this.level) {
            case Original: {
                return ByteUtils.toSoftBytes(fft);
            }
        }
        return ByteUtils.toHardBytes(fft);
    }

    private byte[] doFftMaximal(double[] fft) {
        byte[] bytes = ByteUtils.toSoftBytes(fft);
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            if (this.isSimpleData(bytes, i)) {
                result[i] = bytes[i];
                continue;
            }
            result[Math.max((int)(i - 1), (int)0)] = (byte)(bytes[i] / 2);
            result[Math.min((int)(i + 1), (int)(result.length - 1))] = (byte)(bytes[i] / 2);
        }
        return result;
    }

    private boolean isSimpleData(byte[] data, int i) {
        int start = Math.max(0, i - 5);
        int end = Math.min(data.length, i + 5);
        byte max = 0;
        byte min = 127;
        for (int j = start; j < end; ++j) {
            if (data[j] > max) {
                max = data[j];
            }
            if (data[j] >= min) continue;
            min = data[j];
        }
        return data[i] == min || data[i] == max;
    }

    public static enum Level {
        Original,
        Music,
        People,
        Maximal;

    }
}

