/*
 * Decompiled with CFR 0.152.
 */
package fftlib;

import fftlib.Complex;

public class FFT {
    private static final int SIZE = 4096;

    public static Complex[] fft(Complex[] x) {
        int n = x.length;
        if (n == 1) {
            return new Complex[]{x[0]};
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("n is not a power of 2");
        }
        Complex[] even = new Complex[n / 2];
        for (int k = 0; k < n / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = FFT.fft(even);
        for (int k = 0; k < n / 2; ++k) {
            even[k] = x[2 * k + 1];
        }
        Complex[] r = FFT.fft(even);
        Complex[] y = new Complex[n];
        for (int k = 0; k < n / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)n;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].plus(wk.times(r[k]));
            y[k + n / 2] = q[k].minus(wk.times(r[k]));
        }
        return y;
    }

    public static double[] fft(double[] x, int sc) {
        int len = x.length;
        if (len == 1) {
            return x;
        }
        Complex[] cs = new Complex[len];
        double[] ds = new double[len / 2];
        for (int i = 0; i < len; ++i) {
            cs[i] = new Complex(x[i], 0.0);
        }
        Complex[] ffts = FFT.fft(cs);
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = Math.sqrt(Math.pow(ffts[i].re(), 2.0) + Math.pow(ffts[i].im(), 2.0)) / (double)x.length;
        }
        return ds;
    }

    public static Complex[] ifft(Complex[] x) {
        int i;
        int n = x.length;
        Complex[] y = new Complex[n];
        for (i = 0; i < n; ++i) {
            y[i] = x[i].conjugate();
        }
        y = FFT.fft(y);
        for (i = 0; i < n; ++i) {
            y[i] = y[i].conjugate();
        }
        for (i = 0; i < n; ++i) {
            y[i] = y[i].scale(1.0 / (double)n);
        }
        return y;
    }

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        int n = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[n];
        for (int i = 0; i < n; ++i) {
            c[i] = a[i].times(b[i]);
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        int i;
        int i2;
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            a[i2] = x[i2];
        }
        for (i2 = x.length; i2 < 2 * x.length; ++i2) {
            a[i2] = ZERO;
        }
        Complex[] b = new Complex[2 * y.length];
        for (i = 0; i < y.length; ++i) {
            b[i] = y[i];
        }
        for (i = y.length; i < 2 * y.length; ++i) {
            b[i] = ZERO;
        }
        return FFT.cconvolve(a, b);
    }

    public static void show(Complex[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i = 0; i < 4096; ++i) {
            System.out.println(x[i]);
        }
        System.out.println();
    }

    public static double fun(int x) {
        return Math.sin(15.0f * (float)x);
    }

    public static double getY(double[] d) {
        double y = 0.0;
        int x = 0;
        for (int i = 0; i < d.length; ++i) {
            if (!(d[i] > y)) continue;
            y = d[i];
            x = i;
        }
        FFT.log(String.format("x\uff1a %s \uff0c y: %s", ++x, y));
        FFT.log(String.format("\u9891\u7387\uff1a %sHz", Float.valueOf((float)x / 4096.0f)));
        FFT.log(String.format("\u9891\u73872\uff1a %sHz", Float.valueOf((float)(4096 - x) / 4096.0f)));
        FFT.log(String.format("\u632f\u5e45\uff1a %s", y));
        return y;
    }

    public static void log(String s) {
        System.out.println(s);
    }
}

