/*
 * Decompiled with CFR 0.152.
 */
package fftlib;

import java.util.Objects;

public class Complex {
    private final double real;
    private final double im;

    public Complex(double real, double imag) {
        this.real = real;
        this.im = imag;
    }

    public String toString() {
        return String.format("hypot: %s, complex: %s+%si", this.hypot(), this.real, this.im);
    }

    public double hypot() {
        return Math.hypot(this.real, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.real);
    }

    public Complex plus(Complex b) {
        double real = this.real + b.real;
        double imag = this.im + b.im;
        return new Complex(real, imag);
    }

    public Complex minus(Complex b) {
        double real = this.real - b.real;
        double imag = this.im - b.im;
        return new Complex(real, imag);
    }

    public Complex times(Complex b) {
        Complex a = this;
        double real = a.real * b.real - a.im * b.im;
        double imag = a.real * b.im + a.im * b.real;
        return new Complex(real, imag);
    }

    public Complex scale(double alpha) {
        return new Complex(alpha * this.real, alpha * this.im);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.im);
    }

    public Complex reciprocal() {
        double scale = this.real * this.real + this.im * this.im;
        return new Complex(this.real / scale, -this.im / scale);
    }

    public double re() {
        return this.real;
    }

    public double im() {
        return this.im;
    }

    public Complex divides(Complex b) {
        Complex a = this;
        return a.times(b.reciprocal());
    }

    public Complex exp() {
        return new Complex(Math.exp(this.real) * Math.cos(this.im), Math.exp(this.real) * Math.sin(this.im));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.real) * Math.cosh(this.im), Math.cos(this.real) * Math.sinh(this.im));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.real) * Math.cosh(this.im), -Math.sin(this.real) * Math.sinh(this.im));
    }

    public Complex tan() {
        return this.sin().divides(this.cos());
    }

    public static Complex plus(Complex a, Complex b) {
        double real = a.real + b.real;
        double imag = a.im + b.im;
        Complex sum = new Complex(real, imag);
        return sum;
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (this.getClass() != x.getClass()) {
            return false;
        }
        Complex that = (Complex)x;
        return this.real == that.real && this.im == that.im;
    }

    public int hashCode() {
        return Objects.hash(this.real, this.im);
    }
}

