/*
 * Decompiled with CFR 0.152.
 */
package fftlib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteUtils {
    private static final String TAG = ByteUtils.class.getSimpleName();

    public static byte[] toBytes(short[] src) {
        int count = src.length;
        byte[] dest = new byte[count << 1];
        for (int i = 0; i < count; ++i) {
            dest[i * 2] = (byte)src[i];
            dest[i * 2 + 1] = (byte)(src[i] >> 8);
        }
        return dest;
    }

    public static byte[] toBytes(float f) {
        int fbit = Float.floatToIntBits(f);
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(fbit >> 24 - i * 8);
        }
        int len = b.length;
        byte[] dest = new byte[len];
        System.arraycopy(b, 0, dest, 0, len);
        for (int i = 0; i < len / 2; ++i) {
            byte temp = dest[i];
            dest[i] = dest[len - i - 1];
            dest[len - i - 1] = temp;
        }
        return dest;
    }

    public static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    public static byte[] toBytes(short src) {
        byte[] dest = new byte[]{(byte)src, (byte)(src >> 8)};
        return dest;
    }

    public static byte[] toBytes(int i) {
        byte[] b = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return b;
    }

    public static byte[] toBytes(String str) {
        return str.getBytes();
    }

    public static byte[] toBytes(long number) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, number);
        return buffer.array();
    }

    public static int toInt(byte[] src, int offset) {
        return src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
    }

    public static int toInt(byte[] src) {
        return ByteUtils.toInt(src, 0);
    }

    public static long toLong(byte[] b) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(b, 0, b.length);
        return buffer.getLong();
    }

    public static short[] toShorts(byte[] src) {
        int count = src.length >> 1;
        short[] dest = new short[count];
        for (int i = 0; i < count; ++i) {
            dest[i] = (short)(src[i * 2] & 0xFF | (src[2 * i + 1] & 0xFF) << 8);
        }
        return dest;
    }

    public static byte[] merger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    public static String toString(byte[] b) {
        return Arrays.toString(b);
    }

    public static void byte2File(byte[] buf, File file) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            long fileLength = file.length();
            randomAccessFile.seek(fileLength);
            randomAccessFile.write(buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] byte2FileForResult(byte[] buf, File file) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            long fileLength = file.length();
            randomAccessFile.seek(fileLength);
            randomAccessFile.write(buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ByteUtils.file2Bytes(file);
    }

    public static byte[] file2Bytes(File file) {
        byte[] buffer = null;
        try (FileInputStream fis = new FileInputStream(file);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int n;
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public static double[] toHardDouble(short[] shorts) {
        int length = 512;
        double[] ds = new double[length];
        for (int i = 0; i < length; ++i) {
            ds[i] = shorts[i];
        }
        return ds;
    }

    public static byte[] toHardBytes(double[] doubles) {
        byte[] bytes = new byte[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            double item = doubles[i];
            bytes[i] = (byte)(item > 127.0 ? 127.0 : item);
        }
        return bytes;
    }

    public static short[] toHardShort(double[] doubles) {
        short[] bytes = new short[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            double item = doubles[i];
            bytes[i] = (short)(item > 32767.0 ? 32767.0 : item);
        }
        return bytes;
    }

    public static byte[] toSoftBytes(double[] doubles) {
        double max = ByteUtils.getMax(doubles);
        double sc = 1.0;
        if (max > 127.0) {
            sc = max / 128.0;
        }
        byte[] bytes = new byte[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            double item = doubles[i] / sc;
            bytes[i] = (byte)(item > 127.0 ? 127.0 : item);
        }
        return bytes;
    }

    public static short[] toSoftShorts(double[] doubles) {
        double max = ByteUtils.getMax(doubles);
        double sc = 1.0;
        if (max > 127.0) {
            sc = max / 128.0;
        }
        short[] bytes = new short[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            double item = doubles[i] / sc;
            bytes[i] = (short)(item > 32767.0 ? 32767.0 : item);
        }
        return bytes;
    }

    public static double getMax(double[] data) {
        double max = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }
}

