/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.utils;

import com.zlw.main.recorderlib.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class RecordUtils {
    public static long getMaxDecibels(byte[] input) {
        short[] amplitudes = ByteUtils.toShorts(input);
        if (amplitudes == null) {
            return 0L;
        }
        float maxAmplitude = 2.0f;
        short[] sArray = amplitudes;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            float amplitude = sArray[i];
            if (!(Math.abs(maxAmplitude) < Math.abs(amplitude))) continue;
            maxAmplitude = amplitude;
        }
        return Math.round(20.0 * Math.log10(maxAmplitude));
    }

    public static float[] byteToFloat(byte[] input) {
        if (input == null) {
            return null;
        }
        int bytesPerSample = 2;
        ByteBuffer buffer = ByteBuffer.wrap(input);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = FloatBuffer.allocate(input.length / bytesPerSample);
        for (int i = 0; i < floatBuffer.capacity(); ++i) {
            floatBuffer.put(buffer.getShort(i * bytesPerSample));
        }
        return floatBuffer.array();
    }
}

