/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Environment;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.util.Locale;

public class Logger {
    private static final String PRE = "^_^";
    private static final String TAG = Logger.class.getSimpleName();
    private static final int LOG_LENGTH_LIMITATION = 4000;
    public static boolean IsDebug = true;
    private static final String space = "====================================================================================================";
    private static boolean LOGV = true;
    private static boolean LOGD = true;
    private static boolean LOGI = true;
    private static boolean LOGW = true;
    private static boolean LOGE = true;

    public static void v(String tag, String format, Object ... args) {
        if (LOGV) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.v((String)tag, (String)message);
            Logger.cacheLongLog(tag, message);
        }
    }

    public static void v(Throwable throwable, String tag, String format, Object ... args) {
        if (LOGV) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.v((String)tag, (String)message, (Throwable)throwable);
            Logger.cacheLongLog(tag, message, throwable);
        }
    }

    public static void d(String tag, String format, Object ... args) {
        if (LOGD) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.d((String)tag, (String)message);
            Logger.cacheLongLog(tag, message);
        }
    }

    public static void d(Throwable throwable, String tag, String format, Object ... args) {
        if (LOGD) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.d((String)tag, (String)message, (Throwable)throwable);
            Logger.cacheLongLog(tag, message, throwable);
        }
    }

    public static void i(String tag, String format, Object ... args) {
        if (LOGI) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.i((String)tag, (String)message);
            Logger.cacheLongLog(tag, message);
        }
    }

    public static void i(Throwable throwable, String tag, String format, Object ... args) {
        if (LOGI) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.i((String)tag, (String)message, (Throwable)throwable);
            Logger.cacheLongLog(tag, message, throwable);
        }
    }

    public static void w(String tag, String format, Object ... args) {
        if (LOGW) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.w((String)tag, (String)message);
            Logger.cacheLongLog(tag, message);
        }
    }

    public static void w(Throwable throwable, String tag, String format, Object ... args) {
        if (LOGW) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.w((String)tag, (String)message, (Throwable)throwable);
            Logger.cacheLongLog(tag, message, throwable);
        }
    }

    public static void e(String tag, String format, Object ... args) {
        if (LOGE) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.e((String)tag, (String)message);
            Logger.cacheLongLog(tag, message);
        }
    }

    public static void e(Throwable throwable, String tag, String format, Object ... args) {
        if (LOGE) {
            String message = Logger.buildMessage(format, args);
            tag = Logger.formatLength(PRE + tag, 28);
            Log.e((String)tag, (String)message, (Throwable)throwable);
            Logger.cacheLongLog(tag, message, throwable);
        }
    }

    private static void cacheLongLog(String tag, String logContent) {
        Logger.cacheLongLog(tag, logContent, null);
    }

    @TargetApi(value=19)
    private static void cacheLongLog(String tag, String logContent, Throwable throwable) {
    }

    public static void printCaller() {
        if (!IsDebug) {
            return;
        }
        try {
            StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
            StringBuilder infoBuffer = new StringBuilder();
            infoBuffer.append("print caller info\n==========BEGIN OF CALLER INFO============\n");
            for (int i = 2; i < trace.length; ++i) {
                String callingClass = trace[i].getClassName();
                callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
                String caller = trace[i].getMethodName();
                String callFile = trace[i].getFileName();
                int lineNumber = trace[i].getLineNumber();
                String method = String.format(Locale.US, "[%03d] %s.%s(%s:%d)", Thread.currentThread().getId(), callingClass, caller, callFile, lineNumber);
                infoBuffer.append(method);
                infoBuffer.append("\n");
            }
            infoBuffer.append("==========END OF CALLER INFO============");
            Logger.i(TAG, infoBuffer.toString(), new Object[0]);
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
        }
    }

    private static String buildMessage(String format, Object[] args) {
        try {
            String msg;
            String string = msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
            if (!IsDebug) {
                return msg;
            }
            StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
            String caller = "";
            String callingClass = "";
            String callFile = "";
            int lineNumber = 0;
            for (int i = 2; i < trace.length; ++i) {
                Class<?> clazz = trace[i].getClass();
                if (clazz.equals(Logger.class)) continue;
                callingClass = trace[i].getClassName();
                callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
                caller = trace[i].getMethodName();
                callFile = trace[i].getFileName();
                lineNumber = trace[i].getLineNumber();
                break;
            }
            String method = String.format(Locale.US, "[%03d] %s.%s(%s:%d)", Thread.currentThread().getId(), callingClass, caller, callFile, lineNumber);
            return String.format(Locale.US, "%s> %s", Logger.formatLength(method, 93), msg);
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
            return "----->ERROR LOG STRING<------";
        }
    }

    private static String formatLength(String src, int len) {
        StringBuilder sb = new StringBuilder();
        if (src.length() >= len) {
            sb.append(src);
        } else {
            sb.append(src);
            sb.append(space.substring(0, len - src.length()));
        }
        return sb.toString();
    }

    @TargetApi(value=19)
    public static File getAvailableExternalCacheDir(Context ctx) {
        File[] cacheDirectories = ctx.getExternalCacheDirs();
        for (int index = cacheDirectories.length - 1; index >= 0; --index) {
            File file = cacheDirectories[index];
            if (null == file || !"mounted".equals(Environment.getStorageState((File)file))) continue;
            return file;
        }
        return null;
    }

    public static boolean isFileExists(String filePath) {
        return Logger.isFileExists(new File(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static class TimeCalculator {
        long start = SystemClock.elapsedRealtime();

        public long end() {
            return SystemClock.elapsedRealtime() - this.start;
        }
    }

    public static enum LogLevel {
        V,
        D,
        I,
        W,
        E;

    }
}

