/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.utils;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class FileUtils {
    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static File getFileByPath(String filePath) {
        return FileUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getNowString(DateFormat format) {
        return FileUtils.millis2String(System.currentTimeMillis(), format);
    }

    public static String millis2String(long millis, DateFormat format) {
        return format.format(new Date(millis));
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }
}

