/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteUtils {
    public static byte[] toBytes(short[] src) {
        int count = src.length;
        byte[] dest = new byte[count << 1];
        for (int i = 0; i < count; ++i) {
            dest[i * 2] = (byte)src[i];
            dest[i * 2 + 1] = (byte)(src[i] >> 8);
        }
        return dest;
    }

    public static byte[] toBytes(short src) {
        byte[] dest = new byte[]{(byte)src, (byte)(src >> 8)};
        return dest;
    }

    public static byte[] toBytes(int i) {
        byte[] b = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return b;
    }

    public static byte[] toBytes(String str) {
        return str.getBytes();
    }

    public static byte[] toBytes(long number) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, number);
        return buffer.array();
    }

    public static int toInt(byte[] src, int offset) {
        return src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
    }

    public static int toInt(byte[] src) {
        return ByteUtils.toInt(src, 0);
    }

    public static long toLong(byte[] b) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(b, 0, b.length);
        return buffer.getLong();
    }

    public static short[] toShorts(byte[] src) {
        int count = src.length >> 1;
        short[] dest = new short[count];
        for (int i = 0; i < count; ++i) {
            dest[i] = (short)(src[i * 2] & 0xFF | (src[2 * i + 1] & 0xFF) << 8);
        }
        return dest;
    }

    public static byte[] merger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    public static String toString(byte[] b) {
        return Arrays.toString(b);
    }
}

