/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.recorder.wav;

import com.zlw.main.recorderlib.recorder.RecordConfig;
import com.zlw.main.recorderlib.utils.ByteUtils;
import com.zlw.main.recorderlib.utils.FileUtils;
import com.zlw.main.recorderlib.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavUtils {
    private static final String TAG = WavUtils.class.getSimpleName();

    public static byte[] generateWavFileHeader(int totalAudioLen, int sampleRate, int channels, int sampleBits) {
        WavHeader wavHeader = new WavHeader(totalAudioLen, sampleRate, (short)channels, (short)sampleBits);
        return wavHeader.getHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHeader(File file, byte[] header) {
        if (!FileUtils.isFile(file)) {
            return;
        }
        RandomAccessFile wavRaf = null;
        try {
            wavRaf = new RandomAccessFile(file, "rw");
            wavRaf.seek(0L);
            wavRaf.write(header);
            wavRaf.close();
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (wavRaf != null) {
                    wavRaf.close();
                }
            }
            catch (IOException e) {
                Logger.e(e, TAG, e.getMessage(), new Object[0]);
            }
        }
    }

    public static void pcmToWav(File pcmFile, byte[] header) throws IOException {
        if (!FileUtils.isFile(pcmFile)) {
            return;
        }
        String pcmPath = pcmFile.getAbsolutePath();
        String wavPath = pcmPath.substring(0, pcmPath.length() - 4) + ".wav";
        WavUtils.writeHeader(new File(wavPath), header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getHeader(String wavFilePath) {
        if (!new File(wavFilePath).isFile()) {
            return null;
        }
        byte[] buffer = null;
        File file = new File(wavFilePath);
        int size = 44;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream(44);
            byte[] b = new byte[44];
            int len = fis.read(b);
            if (len != 44) {
                Logger.e(TAG, "\u8bfb\u53d6\u5931\u8d25 len: %s", len);
                byte[] byArray = null;
                return byArray;
            }
            bos.write(b, 0, len);
            buffer = bos.toByteArray();
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (bos != null) {
                    bos.close();
                    bos = null;
                }
            }
            catch (IOException e) {
                Logger.e(e, TAG, e.getMessage(), new Object[0]);
            }
        }
        return buffer;
    }

    public static long getWavDuration(String filePath) {
        if (!filePath.endsWith(RecordConfig.RecordFormat.WAV.getExtension())) {
            return -1L;
        }
        byte[] header = WavUtils.getHeader(filePath);
        return WavUtils.getWavDuration(header);
    }

    public static long getWavDuration(byte[] header) {
        if (header == null || header.length < 44) {
            Logger.e(TAG, "header size\u6709\u8bef", new Object[0]);
            return -1L;
        }
        int byteRate = ByteUtils.toInt(header, 28);
        int waveSize = ByteUtils.toInt(header, 40);
        return (long)waveSize * 1000L / (long)byteRate;
    }

    public static String headerToString(byte[] header) {
        int i;
        if (header == null || header.length < 44) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            stringBuilder.append((char)header[i]);
        }
        stringBuilder.append(",");
        stringBuilder.append(ByteUtils.toInt(header, 4));
        stringBuilder.append(",");
        for (i = 8; i < 16; ++i) {
            stringBuilder.append((char)header[i]);
        }
        stringBuilder.append(",");
        for (i = 16; i < 24; ++i) {
            stringBuilder.append(header[i]);
        }
        stringBuilder.append(",");
        stringBuilder.append(ByteUtils.toInt(header, 24));
        stringBuilder.append(",");
        stringBuilder.append(ByteUtils.toInt(header, 28));
        stringBuilder.append(",");
        for (i = 32; i < 36; ++i) {
            stringBuilder.append(header[i]);
        }
        stringBuilder.append(",");
        for (i = 36; i < 40; ++i) {
            stringBuilder.append((char)header[i]);
        }
        stringBuilder.append(",");
        stringBuilder.append(ByteUtils.toInt(header, 40));
        return stringBuilder.toString();
    }

    public static class WavHeader {
        final String riffChunkId = "RIFF";
        int riffChunkSize;
        final String riffType = "WAVE";
        final String formatChunkId = "fmt ";
        final int formatChunkSize = 16;
        final short audioFormat = 1;
        short channels;
        int sampleRate;
        int byteRate;
        short blockAlign;
        short sampleBits;
        final String dataChunkId = "data";
        int dataChunkSize;

        WavHeader(int totalAudioLen, int sampleRate, short channels, short sampleBits) {
            this.riffChunkSize = totalAudioLen;
            this.channels = channels;
            this.sampleRate = sampleRate;
            this.byteRate = sampleRate * sampleBits / 8 * channels;
            this.blockAlign = (short)(channels * sampleBits / 8);
            this.sampleBits = sampleBits;
            this.dataChunkSize = totalAudioLen - 44;
        }

        public byte[] getHeader() {
            byte[] result = ByteUtils.merger(ByteUtils.toBytes("RIFF"), ByteUtils.toBytes(this.riffChunkSize));
            result = ByteUtils.merger(result, ByteUtils.toBytes("WAVE"));
            result = ByteUtils.merger(result, ByteUtils.toBytes("fmt "));
            result = ByteUtils.merger(result, ByteUtils.toBytes(16));
            result = ByteUtils.merger(result, ByteUtils.toBytes((short)1));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.channels));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.sampleRate));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.byteRate));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.blockAlign));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.sampleBits));
            result = ByteUtils.merger(result, ByteUtils.toBytes("data"));
            result = ByteUtils.merger(result, ByteUtils.toBytes(this.dataChunkSize));
            return result;
        }
    }
}

